DELIMITER $$
DROP PROCEDURE IF EXISTS V20230710164529__Update_DlRecipientUpdateSubmitApplication $$
CREATE PROCEDURE V20230710164529__Update_DlRecipientUpdateSubmitApplication()
BEGIN
SET SQL_SAFE_UPDATES=0;


IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_DL')) THEN 
SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_DL');
 update sql_dtprovider set sqlQuery="SELECT T2.id AS USER_ID FROM application T1
inner join application_program T2 ON T2.applicationId = T1.id WHERE T1.id IN  (namedParams) " where dataProviderId=@dataProviderId;
END IF; 


IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_FORM_SUBMIT_RECIPIENTS')) THEN 
SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_FORM_SUBMIT_RECIPIENTS');
 update sql_dtprovider set sqlQuery="SELECT 
     T6.id AS ID,
     T2.`firstName` AS FIRST_NAME,
     T2.`middleName` AS MIDDLE_NAME,
     T2.`lastName` AS LAST_NAME,
     T2.`emailId` AS EMAIL_ID,
     T2.`mobileNumber` AS MOBILE_NO,
     T1.`code` AS APPLICATION_CODE,
     T2.`mobileCountryCode` AS MOBILE_CODE,
     T2.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
     ml.`code` AS LANGUAGE_KEY,
     'APPLICANT' AS USER_TYPE_KEY,
     T9.programName AS PROGRAM,
     T8.batchName AS INTAKE,
     T11.itemValue AS INTAKE_YEAR,
     ml.itemValue AS CORRESPONDENCE_LANGUAGE,
     T12.itemValue AS CURRENT_ACTIVITY,
     T10.groupName AS PROGRAM_GROUP_NAME
 FROM
     application T1
         LEFT OUTER JOIN
     applicant_person T2 ON T1.applicantPersonId = T2.id
         LEFT OUTER JOIN
     `current_activity` T12 ON T12.`id` = T2.`current_activity_id`
         LEFT OUTER JOIN
     external_user_association T5 ON T5.applicationId = T1.id
         LEFT OUTER JOIN
     external_users T4 ON T4.id = T5.externalUserId
         LEFT OUTER JOIN
     multi_language ml ON ml.id = T2.correspondence_language
         LEFT OUTER JOIN
     application_program T6 ON T6.applicationId = T1.id
        LEFT OUTER JOIN
     prog_batch_seat_config T7 ON T7.id = T6.progBatchSeatConfigId
         INNER JOIN
     batches T8 ON T8.id = T7.programBatchId
         INNER JOIN
     programs T9 ON T9.id = T8.programId
         LEFT OUTER JOIN
     program_group T10 ON T10.id = T9.programGroupId
         INNER JOIN
     intake_year T11 ON T11.id = T8.intakeYearId 
 WHERE
     T6.id IN (namedParams) group by T6.id " where dataProviderId=@dataProviderId;
END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230710164529__Update_DlRecipientUpdateSubmitApplication () $$
DROP PROCEDURE IF EXISTS V20230710164529__Update_DlRecipientUpdateSubmitApplication $$
DELIMITER ;