DELIMITER $$
DROP PROCEDURE IF EXISTS V20230728153212__Create_ApplicantHealth_DropDown $$
CREATE PROCEDURE V20230728153212__Create_ApplicantHealth_DropDown()
BEGIN
IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_health_medical_condition')) THEN 
CREATE TABLE `applicant_health_medical_condition` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`healthId` BIGINT(20) NOT NULL,
	`medicalConditionId` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
    CONSTRAINT `fk_Applicant_health_medicalcondition_healthId_idx` FOREIGN KEY (`healthId`) REFERENCES `applicant_health_details` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    CONSTRAINT `fk_Applicant_health_medical_conditionId_idx` FOREIGN KEY (`medicalConditionId`) REFERENCES `drop_down` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_health_medication')) THEN
CREATE TABLE `applicant_health_medication` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`healthId` BIGINT(20) NOT NULL,
	`medicationId` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
    CONSTRAINT `fk_Applicant_healthmedication_healthId_idx` FOREIGN KEY (`healthId`) REFERENCES `applicant_health_details` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    CONSTRAINT `fk_Applicant_health_medication_medicationId_idx` FOREIGN KEY (`medicationId`) REFERENCES `drop_down` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_health_allergies')) THEN
CREATE TABLE `applicant_health_allergies` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`healthId` BIGINT(20) NOT NULL,
	`allergieId` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
    CONSTRAINT `fk_Applicant_health_allergies_healthId_idx` FOREIGN KEY (`healthId`) REFERENCES `applicant_health_details` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    CONSTRAINT `fk_Applicant_health_allergies_allergieId_idx` FOREIGN KEY (`allergieId`) REFERENCES `drop_down` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_health_learning_difficulties')) THEN
CREATE TABLE `applicant_health_learning_difficulties` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`healthId` BIGINT(20) NOT NULL,
	`learningDifficultieId` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
    CONSTRAINT `fk_Applicant_health_learning_difficulties_healthId_idx` FOREIGN KEY (`healthId`) REFERENCES `applicant_health_details` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    CONSTRAINT `fk_Applicant_health_learning_difficultiesId_idx` FOREIGN KEY (`learningDifficultieId`) REFERENCES `drop_down` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230728153212__Create_ApplicantHealth_DropDown () $$ 
DROP PROCEDURE IF EXISTS V20230728153212__Create_ApplicantHealth_DropDown $$ 
DELIMITER ;