DELIMITER $$
DROP PROCEDURE IF EXISTS V20230731172326__Create_StudentServiceAttendanceTable $$
CREATE PROCEDURE V20230731172326__Create_StudentServiceAttendanceTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_service_attendance')) THEN 
CREATE TABLE `student_service_attendance` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) NOT NULL,
  `programId` bigint(20) NOT NULL,
  `batchId` bigint(20) NOT NULL,
  `seatConfigId` bigint(20) NOT NULL,
  `serviceId` bigint(20) NOT NULL,
  `dateOfAttendance` date NOT NULL,
  `attendanceType` varchar(20) NOT NULL,
  `facultyId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refacademyloc201` (`academyLocationId`),
  KEY `Refprograms202` (`programId`),
  KEY `Refbatches203` (`batchId`),
  KEY `Refusers1465` (`lastUpdatedBy`),
  KEY `Ref_faculty_idx` (`facultyId`),
  KEY `Ref_seatconfig_idx` (`seatConfigId`),
  KEY `Ref_service_idx` (`serviceId`),
  CONSTRAINT `Refusers1466_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `Ref_batch_22` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Ref_faculty_22` FOREIGN KEY (`facultyId`) REFERENCES `staffs` (`personId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Ref_program_22` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Ref_academylocation_22` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Ref_seatconfig_22` FOREIGN KEY (`seatConfigId`) REFERENCES `prog_batch_seat_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Ref_service_22` FOREIGN KEY (`serviceId`) REFERENCES `service` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
);
END IF; 

END $$
CALL V20230731172326__Create_StudentServiceAttendanceTable () $$ 
DROP PROCEDURE IF EXISTS V20230731172326__Create_StudentServiceAttendanceTable $$ 
DELIMITER ;