DELIMITER $$
DROP PROCEDURE IF EXISTS V20230802133451__Create_sch_acc_costcentre_poet_details $$
CREATE PROCEDURE V20230802133451__Create_sch_acc_costcentre_poet_details()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='scholarship_accounting_costcentre_poet_details')) THEN 
CREATE TABLE `scholarship_accounting_costcentre_poet_details` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `scholarshipAccountingSetupId` bigint(20) DEFAULT NULL,
  `costCentreId` BIGINT DEFAULT NULL,
  `costCentreAmount` double(20,2) NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_sch_acc_costcentre_poet_details_to_schAccountingSetup_idx`(`scholarshipAccountingSetupId`),
  INDEX `fk_sch_acc_costcentre_poet_details_to_costCentre_idx` (`costCentreId`),
  INDEX `fk_sch_acc_costcentre_poet_details_to_user_idx` (`lastUpdatedBy`) ,
  
  CONSTRAINT `fk_sch_acc_costcentre_poet_details_to_scholarshipAccountingSetup` 
	FOREIGN KEY (`scholarshipAccountingSetupId`) 
	REFERENCES `scholarship_accounting_setup`(`id`)
    ON DELETE RESTRICT
	ON UPDATE RESTRICT,
  CONSTRAINT `fk_sch_acc_costcentre_poet_details_to_costCentre`
	FOREIGN KEY (`costCentreId`)
	REFERENCES `cost_centre` (`id`)
	ON DELETE RESTRICT
	ON UPDATE RESTRICT,
  CONSTRAINT `fk_sch_acc_costcentre_poet_details_to_user`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);

END IF; 

END $$
CALL V20230802133451__Create_sch_acc_costcentre_poet_details () $$ 
DROP PROCEDURE IF EXISTS V20230802133451__Create_sch_acc_costcentre_poet_details $$ 
DELIMITER ;