DELIMITER $$
DROP PROCEDURE IF EXISTS `syllabusplus_module_info` $$
CREATE PROCEDURE `syllabusplus_module_info`()
BEGIN
select 'Fakt' as academyloc,'Dept' as deptcode,'Vak' as course5char,
'Jg' as course1char,'Mod' as course2char,'Krediet' as coursecredit,'Semester' as yearorsem,'Afr sert naam' as printnamelang2 
union all
select al.id as academyloc, d.shortCode as deptcode, substring(c.coursecode,1,5) as course5char,
if(INSTR(c.coursecode,'-')>0,substring(trim(substring(c.coursecode, INSTR(c.coursecode,'-')+1)),1,1),'') as course1char,
substring(trim(c.coursecode),length(trim(c.coursecode))-1) as course2char,
c.courseCredits as coursecredit, if(pc.isOfferedYearly = 1,3,period.programPeriodSeq) as yearorsem,
c.nameToBePrintedLanguageTwo as printnamelang2 from 
prog_batch_period_config period
inner join batches b on b.id = period.programBatchId
inner join academic_term atrm on atrm.id  = period.academicTermId
inner join program_batch_period_cd pbpcd on pbpcd.progBatchPeriodConfigId  = period.id
inner join categories_info ci on ci.id = pbpcd.cf11
inner join custom_field_config cfc on cfc.id = ci.customFieldConfigId and ci.subCategoryName='Yes'
inner join custom_table_configs ctc on ctc.id = cfc.customTableConfigId and ctc.tablename='prog_batch_period_config'
INNER JOIN intake_year iy ON iy.id = b.intakeYearId
inner join program_courses pc on pc.programBatchId = period.programBatchId
inner join program_courses_period pcp on pcp.programCourseId=pc.id
inner join courses  c on c.id = pc.courseId
inner join courses_departments cd on cd.courseId = c.id
inner join department d on d.id = cd.departmentId
inner join academy_location al on al.id = d.academyLocationId
WHERE period.programPeriodSeq in (1,2)
AND iy.itemvalue = (select value from drop_down where type="Syllabusplus_IntakeYear")
AND atrm.itemValue = (select value from drop_down where type="Syllabusplus_AcademicTerm");
END$$
DELIMITER;