DELIMITER $$
DROP PROCEDURE IF EXISTS V20231010090805__Insert_EmailMarkSheetForRetake $$
CREATE PROCEDURE V20231010090805__Insert_EmailMarkSheetForRetake()
BEGIN

IF NOT EXISTS ((select id from system_msg_event where code='EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS')) THEN 

SET @parentcategoryId=(select id from msg_category where code="EXAMINATION");
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS');

INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS', 'Email Marksheet for Retake Semester Status', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Email Marksheet for Retake Semester Status');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_RECIPIENT', 'SQL');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT T1.admissionId as USER_ID FROM
        	 `marksheet_job_details` T1 
		      WHERE T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
  T1.`id` AS ID,
  T3.firstName AS FIRST_NAME,
   T3.`printName` AS STUDENT_PRINT_NAME,
       T3.lastName AS LAST_NAME,
	   T3.emailId AS EMAIL_ID,
		T2.`code` AS STUDENT_ID,
	   T8.`programNameToBePrint` AS PROGRAM_NAME,
       T10.`printName` AS BATCH_NAME,
	   T11.`printName` AS PERIOD_NAME,
	   T19.`courseCode` AS COURSE_CODE,
       T19.`courseName` AS COURSE_NAME,
       T7.`academyName` AS ACADEMY_NAME,
       T7.`locationName` AS LOCATION_NAME,
       T16.`programExamStatus` as PROGRESSION_STATUS,
        now() as PRINT_DATETIME,
T12.`id` as JOB_ID

 FROM
   marksheet_job_details T12 
    left join 
       admission T1 on T12.admissionId=T1.id
             left join
            users as T2 on T2.id=T1.studentId
            left join 
            persons as T3 on T3.id=T2.id
            left join
            marksheet_job_sub_level as T14 on T14.id=T12.marksheetJobSubLevelId	
            left join
            marksheet_job as T15 on T15.id=T14.marksheetJobId	
            left join 
            academy_location T7 on T7.id=T1.academyLocationId
            left join
            program_batch_students as T16 on T16.progBatchPeriodConfigId=T15.periodId	
            and T16.admissionId=T12.admissionId and T16.sectionId is not null
             left join
            evaluation_plan_rank as T17 on T17.periodId=T15.periodId	
            and T17.admissionId=T12.admissionId 
            left join
            course_variants as T18 on T18.id=T17.courseVariantId	
            and T17.admissionId=T12.admissionId 
             left join
            courses as T19 on T19.id=T18.courseId	
            left join 
            programs T8 on T8.id=T1.programId
            left join 
            prog_batch_seat_config T9 on T9.id=T1.programBatchSeatConfigId
  		   left join 
            prog_batch_period_config T11 on T11.id=T1.programBatchPeriodConfigId
            left join
            batches T10 on T10.id=T9.programBatchId
   WHERE
       T12.admissionId IN (namedParams)  and  T17.status='FAIL' and  T16.programExamStatus is not null
      group by T19.id  ",'{
     "id": 1,
     "searchResultViewColumns": [
	  {
             "id": 1,
             "value": "code",
             "resultKey": "STUDENT_ID",
             "displayCode": "",
             "displayOrder": 0
	   },
        {
             "id": 2,
             "value": "printName",
             "resultKey": "STUDENT_PRINT_NAME",
             "displayCode": "",
             "displayOrder": 1
	   },
 	    {
            "id": 3,
             "value": "programName",
             "resultKey": "PROGRAM_NAME",
             "displayCode": "",
             "displayOrder": 2
 	    },
 	    {
            "id": 4,
             "value": "batchName",
             "resultKey": "BATCH_NAME",
             "displayCode": "",
             "displayOrder": 3
 	   },
       {
            "id": 5,
             "value": "programPeriodName",
             "resultKey": "PERIOD_NAME",
             "displayCode": "",
             "displayOrder": 4
 	   },
       {
             "id": 6,
             "value": "academyName",
             "resultKey": "ACADEMY_NAME",
             "displayCode": "",
             "displayOrder": 5
		},
		{
             "id": 7,
             "value": "locationName",
             "resultKey": "LOCATION_NAME",
             "displayCode": "",
             "displayOrder": 6
         },
         {
             "id": 8,
             "value": "programExamStatus",
             "resultKey": "PROGRESSION_STATUS",
             "displayCode": "",
             "displayOrder": 7
         },
         {
             "id": 9,
             "value": "now()",
             "resultKey": "PRINT_DATETIME",
             "displayCode": "",
             "displayOrder": 8
         }
          
 ]}');

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS');


SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Email Marksheet for Retake Semester Status Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Email Marksheet For Retake Semester status Template',NULL,'',NULL,'','APPROVED','','1','System Admin','1','English',b'1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Your Academic Results',
'<html>
   <head>
<p style="text-align:right"> $recipientData[&quot;printDateTime&quot;]</p>
 <tr>
	<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="https://www.serosoft.com/mailer/sommet/sommet_signature6.png" /></td>
 </tr>
</head>

   <body>
    <p><b><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Progression Panel Results- $recipientData[&quot;studentPrintName&quot;] ($recipientData[&quot;studentCode&quot;]) $recipientData[&quot;batchName&quot;] $recipientData[&quot;programName&quot;] </span></b></p>
        <p>Dear Student,</p>
          <p>The Progression Panel has reviewed your overall performance </p>
          <p> Your results indicate that you have failed resits in: </p>
     
                        #foreach ($Data in $recipientData[&quot;examFailedCourseList&quot;] ) 
                        <tr>
                           <td style="text-align: left">$Data.courseCode</td>
                      	   <td style="text-align: left">$Data.courseName</td>
                           <br>
						</tr>
                        #end
                     
          <p>The Panel has identified that you should retake the above failed course(s).</p>
		  <p>Therefore you will remain in $recipientData[&quot;periodName&quot;] and retake these courses.</p>
          <p>You will be informed nearer the Semester start date which class you are in and which schedule to follow.</p>
          <p>You will receive a transcript of your grades from the Registrar.</p>
          <p>Please check the academic rules and regulations<a href="https://gihe.app.box.com/v/RulesandRegulations"> here </a>before contacting us.</p>
          <p>Once you have read the academic rules and regulations and should you have any further questions regarding:</p>
       
			<p>- Your individual grades: please contact your Faculty members</p>
			</p>- Your academic progression: please contact your Program Team <a href="mailto:bulle.undergraduateprogram@glion.edu">Undergraduate Program Team.</a><br> Best regards.<br>
		Progression Panel</p>
		</ul>
   </body>
</html>



');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'4','Your Academic Results','<html>
   <head>
<p style="text-align:right"> $recipientData[&quot;printDateTime&quot;]</p>
 <tr>
	<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="https://www.serosoft.com/mailer/sommet/sommet_signature6.png" /></td>
 </tr>
</head>

   <body>
    <p><b><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Progression Panel Results- $recipientData[&quot;studentPrintName&quot;] ($recipientData[&quot;studentCode&quot;]) $recipientData[&quot;batchName&quot;] $recipientData[&quot;programName&quot;] </span></b></p>
        <p>Dear Student,</p>
          <p>The Progression Panel has reviewed your overall performance </p>
          <p> Your results indicate that you have failed resits in: </p>
     
                        #foreach ($Data in $recipientData[&quot;examFailedCourseList&quot;] ) 
                        <tr>
                           <td style="text-align: left">$Data.courseCode</td>
                      	   <td style="text-align: left">$Data.courseName</td>
                           <br>
						</tr>
                        #end
                     
          <p>The Panel has identified that you should retake the above failed course(s).</p>
		  <p>Therefore you will remain in $recipientData[&quot;periodName&quot;] and retake these courses.</p>
          <p>You will be informed nearer the Semester start date which class you are in and which schedule to follow.</p>
          <p>You will receive a transcript of your grades from the Registrar.</p>
          <p>Please check the academic rules and regulations<a href="https://gihe.app.box.com/v/RulesandRegulations"> here </a>before contacting us.</p>
          <p>Once you have read the academic rules and regulations and should you have any further questions regarding:</p>
       
			<p>- Your individual grades: please contact your Faculty members</p>
			</p>- Your academic progression: please contact your Program Team <a href="mailto:bulle.undergraduateprogram@glion.edu">Undergraduate Program Team.</a><br> Best regards.<br>
		Progression Panel</p>
		</ul>
   </body>
</html>


');
END IF; 

END $$
CALL V20231010090805__Insert_EmailMarkSheetForRetake() $$
DROP PROCEDURE IF EXISTS V20231010090805__Insert_EmailMarkSheetForRetake $$
DELIMITER ;