DELIMITER $$
DROP PROCEDURE IF EXISTS V20240112112306__Create_Create_StudentAssessmentReport_CSM $$
CREATE PROCEDURE V20240112112306__Create_Create_StudentAssessmentReport_CSM()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_assessment_report') THEN

CREATE TABLE IF NOT EXISTS `student_assessment_report` (
		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
		`columnCode` VARCHAR(255) NOT NULL,
		`isVisible` BIT,
		`lastUpdatedBy` BIGINT(20) NOT NULL,
		`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, 
		PRIMARY KEY (`id`),
		FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
	) ENGINE=InnoDB DEFAULT CHARSET=utf8;

	SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
	SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);  
    
INSERT INTO standard_master(`id`, `tableName`, `masterName`,`moduleName`,`filterCode`, `whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
 VALUES (@standardMasterMaxId + 1, 'student_assessment_report', 'student_assessment_report','Examinations','COMMON_MASTER', 0, 0, '1', NOW());


SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
 VALUES (@ItemsMaxId + 1, 'columnCode', 'COLUMN_NAME', @standardMasterMaxId + 1, 'varchar', '1', 0, 0, 1, 0, '1', NOW());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`,`emunType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`,maxLength, `lastUpdatedBy`, `lastUpdate`)
 VALUES (@ItemsMaxId + 1, 'isVisible', 'Visibility', @standardMasterMaxId + 1, 'Enum','VISIBLITYY', '2', 0, 0, 0, 1,8, '1', NOW());

insert into picklist_enum(enumType, code, enumValue)
values('VISIBLITYY','VISIBLE','Visible' ),
('VISIBLITYY','HIDE','Hide');

INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Assessment Scheme',true,now(),1);
INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Date submitted',true,now(),1);
INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Marks obtained',true,now(),1);
INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Max Marks',true,now(),1);
INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Score (%)',true,now(),1);

INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Effective marks',true,now(),1);  
INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('% Weight',true,now(),1);
INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Weight Score',true,now(),1);
INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Numerical Grade',true,now(),1);
INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Weight Grade',true,now(),1);

INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Assessment code',true,now(),1);
INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Report status',true,now(),1);
INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Published Date',true,now(),1);
INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Program',true,now(),1);
INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Batch',true,now(),1);

INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Period',true,now(),1);
INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Academy Location',true,now(),1);
INSERT INTO student_assessment_report (columnCode,isVisible, lastUpdate, lastUpdatedBy)  VALUES ('Course variant',true,now(),1);

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='masterNames' and keyName='student_assessment_report')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames','student_assessment_report','Student Assessment Report','Student Assessment Report','Studente-assesseringsverslag','Báo cáo đánh giá học sinh',now(),1);     
 
END IF;
END IF;
END $$
CALL V20240112112306__Create_Create_StudentAssessmentReport_CSM () $$ 
DROP PROCEDURE IF EXISTS V20240112112306__Create_Create_StudentAssessmentReport_CSM $$ 
DELIMITER ;