DELIMITER $$
DROP PROCEDURE IF EXISTS V20240123111309__Update_DMUK_INVOICE_STUDENT $$
CREATE PROCEDURE V20240123111309__Update_DMUK_INVOICE_STUDENT()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM `report_template` WHERE reportTypeId = '3' AND templateCode = 'MANAGE_BILLS_STUDENT_CODE' AND templateName='DMUK Invoice - Student')) THEN 
SET @SOAId = (SELECT id FROM report_template WHERE templateCode ='MANAGE_BILLS_STUDENT_CODE' AND templateName='DMUK Invoice - Student');

IF  EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId=@SOAId AND keyValue='TRANS_Discount amount')) THEN 
UPDATE `report_template_translations` SET `defaultValue` = 'Discount Amount' WHERE (`keyValue` = 'TRANS_Discount amount' AND reportTemplateId=@SOAId );
END IF;

IF  EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId=@SOAId AND keyValue='TRANS_Total')) THEN 
UPDATE `report_template_translations` SET `defaultValue` = 'Amount' WHERE (`keyValue` = 'TRANS_Total' AND reportTemplateId=@SOAId );
END IF;

IF  EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId=@SOAId AND keyValue='TRANS_Rate')) THEN 
UPDATE `report_template_translations` SET `defaultValue` = 'Note:' WHERE (`keyValue` = 'TRANS_Rate' AND reportTemplateId=@SOAId );
END IF;

IF  EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId=@SOAId AND keyValue='TRANS_Comment3')) THEN 
UPDATE `report_template_translations` SET `defaultValue` = '3. Below are the discounts applied to the invoice(For more details please visit student portal)' WHERE (`keyValue` = 'TRANS_Comment3' AND reportTemplateId=@SOAId );
END IF;

END IF;
SET SQL_SAFE_UPDATES=1;


IF EXISTS ((SELECT * FROM `report_template` WHERE reportTypeId = '3' AND templateCode = 'MANAGE_BILLS_STUDENT_CODE' AND templateName='DMUK Invoice - Student')) THEN 
SET @reportTempId= (select max(id) from report_template where templateName='DMUK Invoice - Student');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES(@reportTempId , 'TRANS_Please_use', 'Please use the bank details below when making a payment through a foreign bank.', '1', NOW()),
(@reportTempId, 'TRANS_BANK_JSC', 'BANK: JSC Halyk Bank Kazakhstan,', '1', NOW()),
(@reportTempId, 'TRANS_BIC_HSBKKZKX', 'BIC: HSBKKZKX', '1', NOW()),
(@reportTempId, 'TRANS_IIC_USD', 'IIC for USD payment KZ976018861000682341', '1', NOW()),
(@reportTempId, 'TRANS_IIC_GBP', 'IIC for GBP payment KZ216018861000682351', '1', NOW()),
(@reportTempId, 'TRANS_IIC_EUR', 'IIC for EUR payment KZ076018861000810061', '1', NOW());

END IF; 

END $$
CALL V20240123111309__Update_DMUK_INVOICE_STUDENT () $$
DROP PROCEDURE IF EXISTS V20240123111309__Update_DMUK_INVOICE_STUDENT $$
DELIMITER ;