DELIMITER $$
DROP PROCEDURE IF EXISTS V20240221111053__Create_InternalCoSupervisorDDataProvider $$
CREATE PROCEDURE V20240221111053__Create_InternalCoSupervisorDDataProvider()
BEGIN

IF NOT EXISTS ((select * from dydt_data_line_item where dataSourceCode='INTERNAL_CO-SUPERVISOR_D_INFO')) THEN 
INSERT INTO `dydt_data_provider` (`id`,`providerName`, `priority`) VALUES (@dydtdataproviderId+1,'Internal Co-Supervisor D', '1');
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId=(SELECT id FROM `dydt_data_provider` where providerName='Internal Co-Supervisor D');

INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'INTERNAL_CO-SUPERVISOR_D_INFO', '1',null, '1', '1', 
"SELECT T1.id AS id,
T4.firstName AS internal_co_supervisor_d_first_name,
T4.middleName AS internal_co_supervisor_d_middle_name,
T4.lastName AS internal_co_supervisor_d_last_name,
T4.alternateEmailId AS internal_co_supervisor_d_alternative_email_id,
T4.emailId AS internal_co_supervisor_d_email_id,
T4.phoneNo AS internal_co_supervisor_d_telephone_no,
T4.mobileNumber AS internal_co_supervisor_d_mobile_no,
    CONCAT(T7.addressText,',',T9.countryName,',',T10.countryRegionName,',',T7.pincode,',') as internal_co_supervisor_d_address,
T13.code AS internal_co_supervisor_d_id,
T11.salutationName AS internal_co_supervisor_d_title,
T12.itemValue AS internal_co_supervisor_d_gender

from admission
left join users T1 on T1.id=admission.studentId
left join students T2 on T2.userId=T1.id
left join person_functionary_details T3 on T3.personId=T2.personId
left join functionary_type on functionary_type.id=T3.functionaryTypeId 
left join staffs T5 on T5.userId=T3.functionaryUserId and functionary_type.itemCode='Internal Co-Supervisor D'
left join  persons T4 on T4.id=T5.personId
left join person_addresses T6  on T6.personId=T5.personId and T6.addressTypeId=5
left join address T7 on T7.id=T6.addressId
left join city T8 on T8.id=T7.cityId
left join country T9 on T9.id=T8.countryId
left join country_region T10 on T10.id=T8.countryRegionId
left join salutations T11 on T11.id=T4.salutationId
left join gender T12 on T12.id=T4.genderId
left join users T13 on T13.id =T3.functionaryUserId"
,
    'PRM_ADMISSION_ID', 'internal_co_supervisor_d_first_name,internal_co_supervisor_d_middle_name,internal_co_supervisor_d_last_name,internal_co_supervisor_d_address,internal_co_supervisor_d_email_id,internal_co_supervisor_d_alternative_email_id,internal_co_supervisor_d_telephone_no,internal_co_supervisor_d_mobile_no,internal_co_supervisor_d_id,internal_co_supervisor_d_title,internal_co_supervisor_d_gender',
    "WHERE admission.id = PRM_ADMISSION_ID and functionary_type.itemCode='Internal Co-Supervisor D' order by T3.id  desc limit 1;",'0');

#------------------TRANSLATIONS---------------------
   
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('internal_co_supervisor_d_first_name', 'Internal Co-Supervisor D First Name',@dydtdatalinitemId+1),
    ('internal_co_supervisor_d_middle_name', 'Internal Co-Supervisor D Middle Name',@dydtdatalinitemId+1),
    ('internal_co_supervisor_d_last_name', 'Internal Co-Supervisor D Last Name',@dydtdatalinitemId+1),
    ('internal_co_supervisor_d_address', 'Internal Co-Supervisor D Address',@dydtdatalinitemId+1),
    ('internal_co_supervisor_d_email_id', 'Internal Co-Supervisor D Email ID',@dydtdatalinitemId+1),
    ('internal_co_supervisor_d_alternative_email_id', 'Internal Co-Supervisor D Alternative Email ID',@dydtdatalinitemId+1),
    ('internal_co_supervisor_d_telephone_no', 'Internal Co-Supervisor D Telephone No.',@dydtdatalinitemId+1),
    ('internal_co_supervisor_d_mobile_no', 'Internal Co-Supervisor D Mobile No.',@dydtdatalinitemId+1),
    ('internal_co_supervisor_d_id', 'Internal Co-Supervisor D ID',@dydtdatalinitemId+1),
    ('internal_co_supervisor_d_title', 'Internal Co-Supervisor D Title',@dydtdatalinitemId+1),
    ('internal_co_supervisor_d_gender', 'Internal Co-Supervisor D Gender',@dydtdatalinitemId+1);
END IF; 

END $$
CALL V20240221111053__Create_InternalCoSupervisorDDataProvider () $$ 
DROP PROCEDURE IF EXISTS V20240221111053__Create_InternalCoSupervisorDDataProvider $$ 
DELIMITER ;