DELIMITER $$
DROP PROCEDURE IF EXISTS Mark_Entry_Detail $$
CREATE PROCEDURE Mark_Entry_Detail(UserIds text,academyLocationIds text,limitNumber bigint,offsetNumber bigint)
BEGIN
declare limitnumberfinal bigint;
declare offsetNumberfinal bigint;

SET limitnumberfinal = IFNULL(limitNumber, 999999999);
SET offsetNumberfinal = IFNULL(offsetNumber, 0);

SELECT 
	`examination_result`.`id`,
    `examination_result`.`id` AS `examResultHistoryId`,
    `users`.`id` AS `userId`,
    `studentUser`.`firstName` AS `firstName`,
    `studentUser`.`middleName` AS `middleName`,
    `studentUser`.`lastName` AS `lastName`,
    `examination_result`.`admissionId` AS `admissionId`,
    `user_groups`.`userGroupName` AS `userGroupName`,
    `studentUser`.`status` AS `userStatus`,
    `programs`.`programName` AS `programName`,
    `batches`.`batchName` AS `batchName`,
    `prog_batch_period_config`.`programPeriodName` AS `periodName`,
    `sections`.`sectionCode` AS `sectionName`,
    `course_variants`.`courseVariantCode` AS `courseVariantName`,
    `courses`.`courseName` AS `courseName`,
    `studentUser`.`printName` AS `studentName`,
    `studentUser`.`code` AS `studentCode`,
    `studentUser`.`id` AS `studentUserId`,
    `admission`.`code` AS `admissionCode`,
    (CASE
        WHEN (`evaluation_plan`.`whetherDynamicScheme` = 1) THEN `exam_event_detail`.`eventName`
        ELSE `eval_seq_detail`.`detailSequenceNumber`
    END) AS `eventName`,
    `evaluation_plan`.`evaluationPlanNumber` AS `planName`,
    `evaluation_plan_level_one`.`levelName` AS `typeName`,
    `evaluation_plan_level_two`.`levelName` AS `subTypeName`,
    `evaluation_sequence`.`printNameInMarksheet` AS `methodName`,
    (CASE
        WHEN (`eval_seq_detail`.`evalInMarksOrGrade`='MARK') THEN `examination_result`.`effectiveMarks`
        ELSE `examination_result`.`finalGrade`
    END) AS `finalMarks`,
    `students`.`personId` AS `personId`,
    `admission`.`programBatchSeatConfigId` AS `seatConfigId`
FROM
    `examination_result`
        JOIN
    `users` ON `examination_result`.`lastUpdatedBy` = `users`.`id`
        JOIN
    `admission` ON `examination_result`.`admissionId` = `admission`.`id`
        JOIN
    `user_groups` ON `users`.`userGroupId` = `user_groups`.`id`
        JOIN
    `sections` ON `examination_result`.`sectionId` = `sections`.`id`
        JOIN
    `prog_batch_period_config` ON `examination_result`.`periodId` = `prog_batch_period_config`.`id`
        JOIN
    `batches` ON `prog_batch_period_config`.`programBatchId` = `batches`.`id`
        JOIN
    `programs` ON `batches`.`programId` = `programs`.`id`
        LEFT JOIN
    `course_variants` ON `examination_result`.`courseVariantId` = `course_variants`.`id`
        LEFT JOIN
    `courses` ON `course_variants`.`courseId` = `courses`.`id`
        JOIN
    `eval_seq_detail` ON `examination_result`.`evaluationDetailSequenceId` = `eval_seq_detail`.`id`
        LEFT JOIN
    `exam_event_detail` ON `eval_seq_detail`.`id` = `exam_event_detail`.`eventId`
        JOIN
    `evaluation_sequence` ON `eval_seq_detail`.`evalSequenceId` = `evaluation_sequence`.`id`
        JOIN
    `evaluation_plan_level_two` ON `evaluation_sequence`.`evalPlanLevelTwoId` = `evaluation_plan_level_two`.`id`
        JOIN
    `evaluation_plan_level_one` ON `evaluation_plan_level_two`.`evalPlanLevelOneId` = `evaluation_plan_level_one`.`id`
        JOIN
    `evaluation_plan` ON `evaluation_plan_level_one`.`evaluationPlanId` = `evaluation_plan`.`id`
        JOIN
    `students` ON `admission`.`studentId` = `students`.`userId`
		JOIN
    `users` `studentUser` ON `students`.`userId` = `studentUser`.`id`
WHERE
    `examination_result`.`examResultStatus` IS NOT NULL and 
    FIND_IN_SET(programs.academyLocationId, academyLocationIds) and  
    FIND_IN_SET(users.id,UserIds) limit limitnumberfinal offset offsetNumberfinal;


END $$
DELIMITER ;