DELIMITER $$
DROP PROCEDURE IF EXISTS V20240319182744__Create_moodle_deenrollment $$
CREATE PROCEDURE V20240319182744__Create_moodle_deenrollment()
BEGIN

IF EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='moodle_deenrollment') THEN 
drop view moodle_deenrollment;
END IF; 
create view moodle_deenrollment as select map.id, if(map.user_type='STUDENT',5,3) as moodle_roleid, map.academy_locationid, map.course_variant_moodleid, map.user_moodleid from student_course_enrollment enrol
join admission a on enrol.admissionId = a.id
join users u on a.studentId = u.id and a.activeStatus=1
join moodle_user_course_mapping map on map.academia_userid = u.id and enrol.courseVarientId=map.academia_course_variantid and enrol.exitDate is not null
union all
select  map.id, if(map.user_type='STUDENT',5,3) as moodle_roleid, map.academy_locationid, map.course_variant_moodleid, map.user_moodleid from student_course_enrollment enrol
join admission a on enrol.admissionId = a.id
join users u on a.studentId = u.id and a.activeStatus=1 and enrol.isCurrentSection=1
left join moodle_user_course_mapping map on map.academia_userid = u.id and enrol.courseVarientId=map.academia_course_variantid where enrol.id is null;

END $$
CALL V20240319182744__Create_moodle_deenrollment () $$ 
DROP PROCEDURE IF EXISTS V20240319182744__Create_moodle_deenrollment $$ 
DELIMITER ;