DELIMITER $$
DROP PROCEDURE IF EXISTS V20240429141143__Update_StudentProgramCompletionDataGrid $$
CREATE PROCEDURE V20240429141143__Update_StudentProgramCompletionDataGrid()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from data_grid where gridName='Academia.view.student.studentprofile.StudentProgramCompletionDetailsGrid'  and portalId=1)) THEN 
UPDATE `data_grid` set jsonObject=
'[{"id":null,"columnName":"ADMISSION_ID","dataIndex":"admissionId","columnVisibility":"SHOW","sequence":1,"mandatory":false},
  {"id":null,"columnName":"STUDENT_ID","dataIndex":"studentId","columnVisibility":"SHOW","sequence":2,"mandatory":false},
  {"id":null,"columnName":"STUDENT_NAME","dataIndex":"studentName","columnVisibility":"SHOW","sequence":3,"mandatory":false},
  {"id":null,"columnName":"PROGRAM","dataIndex":"program","columnVisibility":"SHOW","sequence":4,"mandatory":false},
  {"id":null,"columnName":"BATCH","dataIndex":"batch","columnVisibility":"SHOW","sequence":5,"mandatory":false},
  {"id":null,"columnName":"DATE_OF_GRADUATION","dataIndex":"dateOfGraduation","columnVisibility":"SHOW","sequence":6,"mandatory":false},
  {"id":null,"columnName":"CLASSIFICATION","dataIndex":"classification","columnVisibility":"SHOW","sequence":7,"mandatory":false},
  {"id":null,"columnName":"IS_ALUMNI","dataIndex":"isAlumni","columnVisibility":"SHOW","sequence":8,"mandatory":false},
  {"id":null,"columnName":"SPECIALIZATION","dataIndex":"specialization","columnVisibility":"SHOW","sequence":9,"mandatory":false},
  {"id":null,"columnName":"AWARD_TYPE","dataIndex":"awardType","columnVisibility":"SHOW","sequence":10,"mandatory":false},
  {"id":null,"columnName":"AWARD_CERTIFICATE_ID","dataIndex":"awardCertificateId","columnVisibility":"SHOW","sequence":11,"mandatory":false},
  {"id":null,"columnName":"AWARD_REQUESTED_DATE","dataIndex":"awardRequestedDate","columnVisibility":"SHOW","sequence":12,"mandatory":false},
  {"id":null,"columnName":"AWARD_SENT_GIVEN_DATE","dataIndex":"awardSentGivenDate","columnVisibility":"SHOW","sequence":13,"mandatory":false},
  {"id":null,"columnName":"AWARD_DELIVERY_METHOD","dataIndex":"awardDeliveryMethod","columnVisibility":"SHOW","sequence":14,"mandatory":false},
  {"id":null,"columnName":"AWARD_NOMINATED_PERSON","dataIndex":"awardNominatedPerson","columnVisibility":"SHOW","sequence":15,"mandatory":false},
  {"id":null,"columnName":"AWARD_TRACKING_NUMBER","dataIndex":"awardTrackingNumber","columnVisibility":"SHOW","sequence":16,"mandatory":false}]' 
  where gridName='Academia.view.student.studentprofile.StudentProgramCompletionDetailsGrid'  and portalId=1; 
END IF; 

IF EXISTS ((select * from student_award_delivery_method_csm where itemCode='Nominated person')) THEN 
UPDATE `student_award_delivery_method_csm` SET itemCode='Nominated Person' , itemValue='Nominated Person' where itemCode='Nominated person' ;
END IF; 

IF EXISTS ((select * from student_award_delivery_method_csm where itemCode='Registered mail')) THEN 
UPDATE `student_award_delivery_method_csm` SET itemCode='Registered Mail' , itemValue='Registered Mail' where itemCode='Registered mail';
END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240429141143__Update_StudentProgramCompletionDataGrid () $$
DROP PROCEDURE IF EXISTS V20240429141143__Update_StudentProgramCompletionDataGrid $$
DELIMITER ;