DELIMITER $$
DROP PROCEDURE IF EXISTS V20240430162317__Insert_IssueOfferLetterEventTrans $$
CREATE PROCEDURE V20240430162317__Insert_IssueOfferLetterEventTrans()
BEGIN

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='HOSTEL_SEND_OFFER_LETTER')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('HOSTEL_SEND_OFFER_LETTER', 'Hostel Issue Offer letter');
END IF; 

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='APPLICANT_HOSTEL_OFFER_LETTER_DL')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('APPLICANT_HOSTEL_OFFER_LETTER_DL', 'Hostel Issue Offer letter DL');
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='APPLICANT_HOSTEL_OFFER_LETTER_RCPNT')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('APPLICANT_HOSTEL_OFFER_LETTER_RCPNT', 'Hostel Issue Offer letter Recipient');
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_SEND_OFFER_LETTER')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_SEND_OFFER_LETTER', 'Hostel Issue Offer letter', 'Hostel Issue Offer letter', 'Koshuisuitreiking Aanbiedingsbrief', 'Thư đề nghị phát hành ký túc xá',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='APPLICANT_HOSTEL_OFFER_LETTER_DL')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'APPLICANT_HOSTEL_OFFER_LETTER_DL', 'Hostel Issue Offer letter DL', 'Hostel Issue Offer letter DL', 'Koshuisuitreiking Aanbiedingsbrief DL', 'Thư mời phát hành ký túc xá DL',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='APPLICANT_HOSTEL_OFFER_LETTER_RCPNT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'APPLICANT_HOSTEL_OFFER_LETTER_RCPNT', 'Hostel Issue Offer letter Recipient', 'Hostel Issue Offer letter Recipient', 'Koshuisuitreiking Aanbiedingsbrief Ontvanger', 'Vấn đề ký túc xá Thư mời nhận Người nhận',now(),1);
END IF;

END $$
CALL V20240430162317__Insert_IssueOfferLetterEventTrans() $$
DROP PROCEDURE IF EXISTS V20240430162317__Insert_IssueOfferLetterEventTrans $$
DELIMITER ;