DELIMITER $$
DROP PROCEDURE IF EXISTS V20240521171117__Create_HostelUnAllocationStudentEvent $$
CREATE PROCEDURE V20240521171117__Create_HostelUnAllocationStudentEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='HOSTEL_UN_ALLOCATION_STUDENT')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='Hostel');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'HOSTEL_UN_ALLOCATION_STUDENT');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='HOSTEL_UN_ALLOCATION_STUDENT');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'HOSTEL_UN_ALLOCATION_STUDENT', 'Hostel Un-allocation Student', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Hostel Un-allocation Student');
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 -- Template data provider for the Event
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'HOSTEL_UN_ALLOCATION_STUDENT_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'HOSTEL_UN_ALLOCATION_STUDENT_RECIPIENT', 'SQL');
 
 -- Create Recipient Type
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_UN_ALLOCATION_STUDENT_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'HOSTEL_UN_ALLOCATION_STUDENT_RECIPIENT');
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_UN_ALLOCATION_STUDENT_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='HOSTEL_UN_ALLOCATION_STUDENT_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
 -- Setting the query for the Applicant distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_UN_ALLOCATION_STUDENT_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT T1.id AS USER_ID FROM student_hostel_application T1 WHERE T1.id IN (namedParams)",NULL);
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_UN_ALLOCATION_STUDENT_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT DISTINCT
    T1.id AS ID,
    T5.code AS HOSTEL_STUDENT_ID,
    T6.firstName AS FIRST_NAME,
	T6.middleName AS MIDDLE_NAME,
	T6.lastName AS LAST_NAME,
	T6.printName AS PRINT_NAME,
	T6.emailId AS EMAIL_ID,
    T6.firstName AS HOSTEL_STUDENT_FIRST_NAME,
    T6.middleName AS HOSTEL_STUDENT_MIDDLE_NAME,
    T6.lastName AS HOSTEL_STUDENT_LAST_NAME,
	T6.printName AS HOSTEL_STUDENT_PRINT_NAME,
	T6.externalSysRefOne AS HOSTEL_EXTERNAL_REFERENCE_NUMBER_ONE,
	T9.salutationName AS HOSTEL_TITLE,
	T6.initials AS HOSTEL_INITIAL,
	T8.itemValue AS HOSTEL_ACADEMIC_TERM,
	T10.code AS HOSTEL_ID,
	T10.resourceName AS HOSTEL_NAME,
	T13.locationName AS HOSTEL_LOCATION,
	T1.unAllocationDate AS UNALLOCATED_DATE,
    ml.code as LANGUAGE_KEY,
	(SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info
        WHERE
            fire_base_persons_info.userId = T5.id) AS DEVICE_ID,
	T6.mobileCountryCode as MOBILE_CODE,
    T6.mobileNumber as MOBILE_NO
FROM
    student_hostel_application T1
		LEFT OUTER JOIN 
    hostel_application_setup T2 ON T2.id = T1.hostelApplicationSetupId
		LEFT OUTER JOIN	
	academic_term T3 ON T3.id = T2.year   
        LEFT OUTER JOIN
    students T4 ON T4.userId = T1.studentId
        LEFT OUTER JOIN 
	users T5 ON T5.id = T4.userId
        LEFT OUTER JOIN
    persons T6 ON T6.id = T4.personId
		LEFT OUTER JOIN
	academic_term T8 on T8.id = T1.hostelApplicationYearId
		LEFT OUTER JOIN
	salutations T9 on T9.id = T6.salutationId
		LEFT OUTER JOIN
	resources T10 on T10.id = T1.unAllocatedHostelId
		LEFT OUTER JOIN
	resource_academy_locations T11 on T11.resourceId = T1.unAllocatedHostelId AND T11.whetherPrimary=TRUE
		LEFT OUTER JOIN
	academy_location T12 on T12.id = T11.academyLocationId
		LEFT OUTER JOIN
	locations T13 on T13.id = T12.locationId
		LEFT OUTER JOIN
	multi_language ml on ml.id = T6.correspondence_language
WHERE
    T1.id IN (namedParams)",'{
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "printName",
            "resultKey": "HOSTEL_STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "HOSTEL_STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "HOSTEL_STUDENT_MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "lastName",
            "resultKey": "HOSTEL_STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "code",
            "resultKey": "HOSTEL_STUDENT_ID",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "externalSysRefOne",
            "resultKey": "HOSTEL_EXTERNAL_REFERENCE_NUMBER_ONE",
            "displayCode": "",
            "displayOrder": 6
        },{
            "id": 8,
            "value": "salutationName",
            "resultKey": "HOSTEL_TITLE",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "initials",
            "resultKey": "HOSTEL_INITIAL",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "locationName",
            "resultKey": "HOSTEL_LOCATION",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "code",
            "resultKey": "HOSTEL_ID",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "resourceName",
            "resultKey": "HOSTEL_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "itemValue",
            "resultKey": "HOSTEL_ACADEMIC_TERM",
            "displayCode": "",
            "displayOrder": 12
        },{
            "id": 14,
            "value": "unAllocationDate",
            "resultKey": "UNALLOCATED_DATE",
            "displayCode": "",
            "displayOrder": 13
        }
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='HOSTEL_UN_ALLOCATION_STUDENT_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='HOSTEL_UN_ALLOCATION_STUDENT');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='HOSTEL_UN_ALLOCATION_STUDENT');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='HOSTEL_UN_ALLOCATION_STUDENT_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Hostel Un-allocation Student',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Hostel Un-allocation Student',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'2','','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'4','','');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+4,@msgtemplateconfigId+1,'6','','');

END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_UN_ALLOCATION_STUDENT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_UN_ALLOCATION_STUDENT', 'Hostel Un-allocation Student', 'Hostel Un-allocation Student', 'Koshuis Un-toekenning Student', 'Sinh viên không phân bổ ký túc xá',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_UN_ALLOCATION_STUDENT_DL')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_UN_ALLOCATION_STUDENT_DL', 'Hostel Un-allocation Student DL', 'Hostel Un-allocation Student DL', 'Koshuis Ontoewysing Student DL', 'Ký túc xá Không phân bổ Sinh viên DL',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_UN_ALLOCATION_STUDENT_RECIPIENT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_UN_ALLOCATION_STUDENT_RECIPIENT', 'Hostel Un-allocation Student Recipient', 'Hostel Un-allocation Student Recipient', 'Koshuis Un-toekenning Student Ontvanger', 'Ký túc xá Không phân bổ Sinh viên nhận',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='HOSTEL_UN_ALLOCATION_STUDENT')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('HOSTEL_UN_ALLOCATION_STUDENT', 'Hostel Un-allocation Student');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='HOSTEL_UN_ALLOCATION_STUDENT_DL')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('HOSTEL_UN_ALLOCATION_STUDENT_DL', 'Hostel Un-allocation Student DL');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='HOSTEL_UN_ALLOCATION_STUDENT_RECIPIENT')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('HOSTEL_UN_ALLOCATION_STUDENT_RECIPIENT', 'Hostel Un-allocation Student Recipient');
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_STUDENT_PRINT_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_STUDENT_PRINT_NAME', 'Student Print Name', 'Student Print Name', 'Student Druk Naam', 'Tên in hoa của học sinh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_STUDENT_FIRST_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_STUDENT_FIRST_NAME', 'Student First Name', 'Student First Name', 'Student Voornaam', 'Tên học sinh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_STUDENT_MIDDLE_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_STUDENT_MIDDLE_NAME', 'Student Middle Name', 'Student Middle Name', 'Student se middelnaam', 'Tên đệm của học sinh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_STUDENT_LAST_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_STUDENT_LAST_NAME', 'Student Last Name', 'Student Last Name', 'Student Van Naam', 'Họ của học sinh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_STUDENT_ID')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_STUDENT_ID', 'Student ID', 'Student ID', 'Studente ID', 'thẻ học sinh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_EXTERNAL_REFERENCE_NUMBER_ONE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_EXTERNAL_REFERENCE_NUMBER_ONE', 'External Reference Number 1', 'External Reference Number 1', 'Eksterne verwysingsnommer 1', 'Số tham chiếu bên ngoài 1',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_TITLE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_TITLE', 'Title', 'Title', 'Titel', 'Tiêu đề',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_INITIAL')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_INITIAL', 'Initial', 'Initial', 'Aanvanklike', 'Ban đầu',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_LOCATION')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_LOCATION', 'Hostel Location', 'Hostel Location', 'Koshuis ligging', 'Vị trí ký túc xá',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_ID')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_ID', 'Hostel ID', 'Hostel ID', 'Koshuis ID', 'Mã ký túc xá',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_NAME')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_NAME', 'Hostel Name', 'Hostel Name', 'Koshuis Naam', 'Tên ký túc xá',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='HOSTEL_ACADEMIC_TERM')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'HOSTEL_ACADEMIC_TERM', 'Academic Term', 'Academic Term', 'Akademiese jaar', 'Năm học',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='UNALLOCATED_DATE')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'UNALLOCATED_DATE', 'Date', 'Date', 'Datum', 'Ngày',now(),1);
END IF;

END $$
CALL V20240521171117__Create_HostelUnAllocationStudentEvent () $$ 
DROP PROCEDURE IF EXISTS V20240521171117__Create_HostelUnAllocationStudentEvent $$ 
DELIMITER ;