DELIMITER $$
DROP PROCEDURE IF EXISTS V20240530154444__Update_BlackboardUserCreationNotification $$
CREATE PROCEDURE V20240530154444__Update_BlackboardUserCreationNotification()
BEGIN
SET SQL_SAFE_UPDATES=0;
SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BLACKBOARD_USER_CREATION_NOTIFICATION_RECIPIENTS');

IF NOT EXISTS ((SELECT * FROM `msg_recipient_type` WHERE code='BLACKBOARD_USER_CREATION_NOTIFICATION_RECIPIENTS')) THEN 
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'BLACKBOARD_USER_CREATION_NOTIFICATION_RECIPIENTS');
END IF;

SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='BLACKBOARD_USER_CREATION_NOTIFICATION_RECIPIENTS');
IF EXISTS ((SELECT * FROM `msg_template_config` WHERE sysMsgEventId in (SELECT id FROM system_msg_event WHERE `code`='BLACKBOARD_USER_CREATION_NOTIFICATION'))) THEN 
update msg_template_config set recipientTypeId=@recipientTypeId where sysMsgEventId in (SELECT id FROM system_msg_event WHERE `code`='BLACKBOARD_USER_CREATION_NOTIFICATION');
END IF;

IF EXISTS (SELECT * FROM `sys_msg_evtrcpt_default_conf` WHERE distrListProviderId in (select id from dtprovider where dataProviderName in ("BLACKBOARD_USER_CREATION_NOTIFICATION_DL","BLACKBOARD_USER_CREATION_NOTIFICATION_RECIPIENTS"))) THEN 
update sys_msg_evtrcpt_default_conf set recipientTypeId=@recipientTypeId  where distrListProviderId in (select id from dtprovider where dataProviderName in ("BLACKBOARD_USER_CREATION_NOTIFICATION_DL","BLACKBOARD_USER_CREATION_NOTIFICATION_RECIPIENTS"));
END IF;


SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240530154444__Update_BlackboardUserCreationNotification () $$
DROP PROCEDURE IF EXISTS V20240530154444__Update_BlackboardUserCreationNotification $$
DELIMITER ;