DELIMITER $$
DROP PROCEDURE IF EXISTS V20240712164813__Create_Readmission_Reason_Child_CSM $$
CREATE PROCEDURE V20240712164813__Create_Readmission_Reason_Child_CSM()
BEGIN

IF NOT EXISTS (((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='readmission_reason_child_csm'))) THEN 
	CREATE TABLE IF NOT EXISTS `readmission_reason_child_csm` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`readmissionReasonId` BIGINT(20) NULL,
	`documentName` VARCHAR(255) NOT NULL,
	`documentType` VARCHAR(255) NOT NULL,
    `visibility` Boolean NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP on update current_timestamp,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
	FOREIGN KEY (`readmissionReasonId`) REFERENCES `readmission_reason_csm`(`id`)
) ENGINE=InnoDB;
END IF;
	
	IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'readmission_reason_child_csm')) THEN 

		SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
		INSERT INTO `standard_master`(`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@standardMasterMaxId+1, 'readmission_reason_child_csm','READMISSION_REASON_CHILD_CSM','Fees & Payments','COMMON_MASTER',1,0,1,SYSDATE());
		
		INSERT INTO `picklist_enum` (`enumType`, `code`, `enumValue`) 
		VALUES ('READMISSION_REASON', 'Mandatory', 'Mandatory');
		INSERT INTO `picklist_enum` (`enumType`, `code`, `enumValue`) 
		VALUES ('READMISSION_REASON', 'Optional', 'Optional');
		
		SET FOREIGN_KEY_CHECKS=0;
		SET SQL_SAFE_UPDATES = 0;
		SET @standardMasterId=(SELECT id FROM standard_master WHERE `tableName`='readmission_reason_child_csm');
		UPDATE `standard_master` SET `childMaster`=@standardMasterId, `whetherParent`=1 WHERE `tableName`='readmission_reason_csm';
		SET SQL_SAFE_UPDATES = 1;
		SET FOREIGN_KEY_CHECKS=1;
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'documentName', 'DOCUMENT_NAME', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1',SYSDATE());
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'visibility', 'VISIBILITY', @standardMasterMaxId+1, 'Boolean', '3', 0, 0, 0, 0, '1',SYSDATE());
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`,`emunType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'documentType', 'DOCUMENT_TYPE', @standardMasterMaxId+1, 'Enum','READMISSION_REASON', '2', 0, 0, 0, 0, '1',SYSDATE());


END IF; 

END $$
CALL V20240712164813__Create_Readmission_Reason_Child_CSM () $$ 
DROP PROCEDURE IF EXISTS V20240712164813__Create_Readmission_Reason_Child_CSM $$ 
DELIMITER ;