DELIMITER $$
DROP PROCEDURE IF EXISTS getDetailsForMoodleMarksGrades $$
CREATE PROCEDURE getDetailsForMoodleMarksGrades(IN academyLocationId INTEGER)
BEGIN
select mt.moodleId as studentMoodleid, mc.moodleCourseId as courseVarMoodleid, 
eseq.detailSequenceNumber as eventName, eseq.weightage, eseq.evalInMarksOrGrade,
eseq.minMarks, eseq.maxMarks, eseq.roundingCount,  eseq.roundingMode,
c.courseGradeType,  c.courseMarksGrades,  er.* 
from examination_result er
join eval_seq_detail eseq on er.evaluationDetailSequenceId = eseq.id
join moodle_course mc on er.courseVariantId = mc.academiaCourseVariantId and mc.hierarchy='PROG_BATCH_PERIOD_COURSE_VARIANT'
join admission a on er.admissionId = a.id and a.activeStatus=true and mc.academyLocationId = a.academyLocationId
join moodle_transaction_info mt on a.studentId = mt.academiaId and mt.moodleTransactionType = 'STUDENT' 
join course_variants cv on er.courseVariantId = cv.id
join courses c on cv.courseId = c.id
join evaluation_type_course etc on er.courseVariantId = etc.courseVariantId and er.sectionId = etc.sectionId and er.periodId = etc.periodId
join course_variant_event_mapping cvem on cvem.evaluationTypeCourseId = etc.id and eseq.id = cvem.eventId and cvem.eventStatus='CONDUCTED'
where  er.examResultStatus is null and a.academyLocationId=academyLocationId;
END $$
DELIMITER ;