DELIMITER $$
DROP PROCEDURE IF EXISTS V20240903103148__Create_TranscriptStringTheorySchoolReport $$
CREATE PROCEDURE V20240903103148__Create_TranscriptStringTheorySchoolReport()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Mark Sheet' );

IF NOT EXISTS ((select * from report_template where templateCode = 'TRANSCRIPT_STRING_THEORY_SCHOOL_OF_DESIGN')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'TRANSCRIPT_STRING_THEORY_SCHOOL_OF_DESIGN', 'Transcript String Theory School of Design', 'TRANSCRIPT_STRING_THEORY_SCHOOL_OF_DESIGN.png', 'CommonReport_TRANSCRIPT_STRING_THEORY_SCHOOL_OF_DESIGN.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'TRANSCRIPT_STRING_THEORY_SCHOOL_OF_DESIGN.jasper', 'AcademiaLogo.png');
END IF; 

set @tempId = (select max(id) from report_template where templateCode='TRANSCRIPT_STRING_THEORY_SCHOOL_OF_DESIGN' and templateName='Transcript String Theory School of Design');

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STRING_SCHOOL_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_STRING_SCHOOL_NAME', 'String Theory School of Design', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_OFFICIAL_TRANSCRIPT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_OFFICIAL_TRANSCRIPT', 'Official College Transcript', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='STUDENT_PERSONAL_INFORMATION') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'STUDENT_PERSONAL_INFORMATION', 'Student Personal Information', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_NAME', 'Name', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_ID') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_ID', 'ID', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DOB') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_DOB', 'DOB', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DATE_OF_ENROLLMENT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_DATE_OF_ENROLLMENT', 'Date of Enrollment', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DATE_OF_GRADUATION') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_DATE_OF_GRADUATION', 'Date of Graduation', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DEGREE_AWARDED') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_DEGREE_AWARDED', 'Degree Awarded', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_ADDRESS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_ADDRESS', 'Address', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_LEARNING_EXPERIENCE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_LEARNING_EXPERIENCE', 'Learning Experience', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_MASTERY_LEVEL') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_MASTERY_LEVEL', 'Mastery Level', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_QUARTER_CREDITS_EARNED') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_QUARTER_CREDITS_EARNED', 'Quarter Credits Earned', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_TYPE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_TYPE', 'Type', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_ACADEMIC_SUMMARY') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_ACADEMIC_SUMMARY', 'Academic Summary', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_GPA') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_GPA', 'GPA', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_TOTAL_CREDITS_EARNED') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_TOTAL_CREDITS_EARNED', 'Total Credits Earned', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_PROGRAM_CONCENTRATION') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_PROGRAM_CONCENTRATION', 'Program/Concentration', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_GRADING_SYSTEM') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_GRADING_SYSTEM', 'Grading System', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_IDEATE_COMPETENCIES') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_IDEATE_COMPETENCIES', 'IDeATE Competencies', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_REV_PROFORMANCE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_REV_PROFORMANCE', '(see reverse for Performance Summary)', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_GRADUATION_COMPETENCIES') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_GRADUATION_COMPETENCIES', 'Graduation Competencies: Performance Summary', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_OFFICIAL_SEALED') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_OFFICIAL_SEALED', 'THIS OFFICIAL COLLEGE TRANSCRIPT IS CERTIFIED AND SEALED AS TRUE AND CORRECT', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_PRINT_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_PRINT_NAME', 'PRINT NAME', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_REGISTRAR') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_REGISTRAR', 'REGISTRAR, STRING THEORY SCHOOL OF DESIGN', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_HONORS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_HONORS', 'Honors:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DEANS_LIST') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_DEANS_LIST', 'Dean’s List:', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DEOTY') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_DEOTY', 'Design Entrepreneur of the Year:', '1', now());
END IF;

END $$
CALL V20240903103148__Create_TranscriptStringTheorySchoolReport () $$ 
DROP PROCEDURE IF EXISTS V20240903103148__Create_TranscriptStringTheorySchoolReport $$ 
DELIMITER ;