DELIMITER $$
DROP PROCEDURE IF EXISTS V20240903170739__Create_passout_map_period $$
CREATE PROCEDURE V20240903170739__Create_passout_map_period()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE() AND table_name='passout_map_period')) THEN 
CREATE TABLE `passout_map_period`(
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`passoutRuleId` BIGINT(20) NOT NULL,
    `periodId` BIGINT(20) NOT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	INDEX `passout_map_period_idx1` (`passoutRuleId` ASC),
	INDEX `passout_map_period_idx2` (`periodId` ASC),
	INDEX `passout_map_period_idx3` (`lastUpdatedBy` ASC),
	CONSTRAINT `fk_passout_map_period_1` FOREIGN KEY (`passoutRuleId`) REFERENCES `passout_rule`(`id`),
    CONSTRAINT `fk_passout_map_period_2` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config`(`id`),
	CONSTRAINT `fk_passout_map_period_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
    );
END IF; 

END $$
CALL V20240903170739__Create_passout_map_period () $$ 
DROP PROCEDURE IF EXISTS V20240903170739__Create_passout_map_period $$ 
DELIMITER ;