DELIMITER $$
DROP PROCEDURE IF EXISTS V20240930182107__Insert_TransferCreditResultStatusCSM $$
CREATE PROCEDURE V20240930182107__Insert_TransferCreditResultStatusCSM()
BEGIN

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'transfer_credit_result_status_csm')) THEN 
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'transfer_credit_result_status_csm','TRANSFER_CREDIT_RESULT_STATUS','Program & Courses','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF; 

IF  EXISTS ((select * from standard_master where tableName = 'transfer_credit_result_status_csm')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'transfer_credit_result_status_csm');
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='ITEM_CODE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterId and fieldLabel='ITEM_VALUE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'TRANSFER_CREDIT_RESULT_STATUS')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'TRANSFER_CREDIT_RESULT_STATUS', 'Transfer Credit Result Status', 'Transfer Credit Result Status','Oordragkredietresultaatstatus','Trạng thái kết quả tín dụng chuyển khoản',now(),1);
END IF; 

END $$
CALL V20240930182107__Insert_TransferCreditResultStatusCSM() $$
DROP PROCEDURE IF EXISTS V20240930182107__Insert_TransferCreditResultStatusCSM $$
DELIMITER ;