DELIMITER $$
DROP PROCEDURE IF EXISTS V20241001101640__Create_UWCTimeTableReport $$
CREATE PROCEDURE V20241001101640__Create_UWCTimeTableReport()
BEGIN

set  @UWCHallTicket = (select max(id) from report_type where typeName='Hall Ticket');
IF NOT EXISTS (SELECT * FROM `report_template` WHERE templateCode = 'UWC_TIME_TABLE_REPORT') THEN 

INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@UWCHallTicket, 'UWC_TIME_TABLE_REPORT', 'UWC Time Table', 'UWC_TIME_TABLE_REPORT.png', 'CommonReport_UWC_TIME_TABLE_REPORT.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'UWC_TIME_TABLE_REPORT.jasper', 'AcademiaLogo.png');
END IF;


IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'UWC_TIME_TABLE_REPORT')) THEN 
set @H1 = (select max(id)  from report_template where templateCode ='UWC_TIME_TABLE_REPORT');
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_EXM_TIME_TBL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_EXM_TIME_TBL', 'Examination Timetable ', '1', now());
END IF; 


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_EXM_PERIOD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_EXM_PERIOD', 'Examination Period', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_STUDENT_NAME', 'Name of the Student', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_STUDENT_NUMBER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_STUDENT_NUMBER', 'Student Number', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_MODULES_SCHE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_MODULES_SCHE', 'Modules Scheduled:', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_MODULES_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_MODULES_CODE', 'Module Code', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_MODULES_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_MODULES_NAME', 'Module Name', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_VENUE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_VENUE', 'Venue', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_EXAMINATION_DATES')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_EXAMINATION_DATES', 'Date of Examinations', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_EXAMINATION_TIME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_EXAMINATION_TIME', 'Time of Examinations', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_EXAM_RULE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_EXAM_RULE', 'EXAMINATION RULES AND REGULATIONS', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_A_GENERAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_A_GENERAL', 'A. GENERAL', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY', 'Students should note the following general examination rules:', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY1A')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY1A', '•   Students should be seated in the venue 30mins before the commencement of the examination.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY2A')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY2A', '•   Students may only use the official examination book(s) issued to them by the invigilator at the examination venue.','1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY3A')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY3A', '•   Students are required to carefully read instructions on the cover of the examination answer book.','1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY4A')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY4A', '•   The University, in the event of any misinterpretation of the timetable, will make no concession.','1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY5A')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY5A', '•   A student’s examination book(s) will not be marked if his/her handwriting is illegible.','1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY6A')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY6A', '•   Students MUST be in possession of a student card when entering the examination venue. No other form of identification will be accepted','1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY7A')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY7A', 'Any breach of the following requirements relating to examinations and assessments may be regarded as “misconduct”, whether committed intentionally or unintentionally, and will be dealt with in terms of the Student Disciplinary Rules of the University.','1', now());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_B_GENERAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_B_GENERAL', 'B. ENTERING AND LEAVING OF EXAMINATION VENUE', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY1B')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY1B', 'Students are not permitted to enter the examination room more than half an hour after commencement of the session.','1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY2B')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY2B', 'Students are not permitted to leave the examination room until one hour after the start of the session or during the last thirty minutes of the session, except with the special permission from the invigilator in charge of the examination who will report on the reasons for leaving to the Department of Student Administration.','1', now());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_C_GENERAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_C_GENERAL', 'C. STUDENT CARDS', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY1C')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY1C', 'Students are required to have photographic identification by means of a student card when entering the examination venue. No other form of identification will be accepted.', '1', now());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_D_GENERAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_D_GENERAL', 'D. EXAMINATION ATTENDANCE FROM (CONTROL FORM)', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY1D')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY1D', 'You will be required to fill out an Examination Attendance Form at the examination venue. The forms will be handed out by the invigilator and collected again shortly after the start of the examination session.', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_F_GENERAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_E_GENERAL', 'E. SMOKING, FOOD AND DRINKS', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY1F')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY1E', 'Students may not smoke, eat or drink in examination venues. Water is permitted.', '1', now());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_F_GENERAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_F_GENERAL', 'F. WRITING TIME', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY1F')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY1F', 'The duration of the examination is indicated in your examination question paper. All writing, including the entry of names or other information on the examination paper, examination answer books, or the numbering of questions should be done during the examination time.', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_G_GENERAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_G_GENERAL', 'G. UNAUTHORISED MATERIAL', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY1G')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY1G', 'Students should not take any books, writing paper, notes, manuscripts, electronic media, including electronic dictionaries, pagers, any form of stored or recorded information, or any other material into the exam venue except with the special permission of the invigilator in charge of the venue.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY2G')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY2G', 'Electronic devices including cellular phones, calculators, electronic diaries and dictionaries are not allowed in examination venues. If such devices are found in the possession of students it will be deemed as a breach of examination rules. Students are advised to leave electronic devices at home. The university will not accept responsibility for lost, stolen or damaged items.Bags and personal belongings brought into the examination venue, will be placed at the student’s feet, under the examination desk/chair.
', '1', now());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_H_GENERAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_H_GENERAL', 'H. EXAMINATION ANSWER BOOKS', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY1H')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY1H', 'Examination answer books must be intact when it is handed to the invigilator. Examination answer books may not be defaced, removed from the venue or destroyed.', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_I_GENERAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_I_GENERAL', 'I. NOTES, ROUGH WORK', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY1I')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY1I', 'All notes, rough work and calculations must be done in a separate examination answer book that must also be handed in at the end of the examination.', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_J_GENERAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_J_GENERAL', 'J. BEHAVIOUR DURING EXAMINATION', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY1J')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY1J', 'All notes, rough work and calculations must be done in a separate examination answer book that must also be handed in at the end of the examination.', '1', now());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_K_GENERAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_K_GENERAL', 'K. TEMPORARILY LEAVING AND EXAMINATION VENUE', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY1K')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY1K', 'Students, who need to leave an examination venue during an examination and return to the examination venue later, must obtain permission from an invigilator. An invigilator must accompany students during their absence from the examination venue.', '1', now());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_L_GENERAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_L_GENERAL', 'L. FAILURE TO ATTEND AN EXAMINATION', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY1L')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY1L', 'Students, who need to leave an examination venue during an examination and return to the examination venue later, must obtain permission from an invigilator. An invigilator must accompany students during their absence from the examination venue.', '1', now());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_M_GENERAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_M_GENERAL', 'M. SPECIAL AND SICK EXAMINATIONS', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_SUMMERY1M')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_SUMMERY1M', 'Application forms for special or sick examinations are available from the faculty office (please email your relevant Faculty). Students should apply within five days following the examination.', '1', now());
END IF;



IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_DEFINTIONS_GLOSSARY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_DEFINTIONS_GLOSSARY', 'DEFINTIONS/GLOSSARY', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_DEFINTIONS_GLOSSARY1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_DEFINTIONS_GLOSSARY1', '•   The word “student”: when appearing in the above-mentioned clauses means any person officially enrolled in a subject or course taught by the University.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_DEFINTIONS_GLOSSARY2')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_DEFINTIONS_GLOSSARY2', '•   The word “invigilator” when appearing in the above-mentioned clauses means members of the University’s academic or general staff or any other person authorised to assume responsibility for supervision and/or organization of a University examination.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_DEFINTIONS_GLOSSARY3')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_DEFINTIONS_GLOSSARY3', '•   The words “examination venue” when appearing in the above-mentioned clauses mean any place in which a University examination shall be or is being conducted.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_DEFINTIONS_GLOSSARY4')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_DEFINTIONS_GLOSSARY4', '•   The term “during an examination”, when appearing in the above-mentioned clauses means the period of time from the start of an examination until its conclusion, and includes any time allowed for reading an examination paper. These rules and regulations where appropriate, will also apply outside an examination venue.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @H1 and keyValue='TRANS_DEFINTIONS_GLOSSARY5')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@H1, 'TRANS_DEFINTIONS_GLOSSARY5', '•   The term “good cause” when applied to exclusion from an examination venue in the above-mentioned text will mean any breach of the requirements or any conduct on the part of a student which can be classified as “misconduct” under University Discipline Statutes or Regulations.', '1', now());
END IF;


END $$
CALL V20241001101640__Create_UWCTimeTableReport () $$ 
DROP PROCEDURE IF EXISTS V20241001101640__Create_UWCTimeTableReport $$ 
DELIMITER ;