DELIMITER $$
DROP PROCEDURE IF EXISTS V20241009171902__Alter_Stripe $$
CREATE PROCEDURE V20241009171902__Alter_Stripe()
BEGIN

IF EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='fk_stripe_id_idx' AND table_name='stripe')  then
ALTER TABLE stripe DROP FOREIGN KEY fk_stripe_id_idx;
END IF;

IF EXISTS (SELECT index_name FROM information_schema.statistics where table_schema=database() and column_name='standardPaymentGatewayId' and table_name='flywire' and index_name='fk_stripe_id_idx') then
ALTER TABLE stripe DROP index fk_stripe_id_idx;
END IF;

IF EXISTS (SELECT * FROM information_schema.columns where table_schema=database() and column_name='academyLocation' and table_name='stripe') then
ALTER TABLE stripe DROP COLUMN academyLocation;
END IF;

IF EXISTS (SELECT * FROM information_schema.columns where table_schema=database() and column_name='standardPaymentGatewayId' and table_name='stripe') then
ALTER TABLE stripe CHANGE COLUMN standardPaymentGatewayId academyLocationId BIGINT NULL DEFAULT NULL;
END IF;

IF NOT EXISTS (SELECT index_name FROM information_schema.statistics where table_schema=database() and table_name='stripe' and index_name='fk_stripe_academyLocation_id') then
ALTER TABLE stripe ADD INDEX fk_stripe_academyLocation_id (academyLocationId);
END IF;

IF NOT EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='fk_stripe_academyLocation_id' AND table_name='stripe') then
ALTER TABLE stripe ADD CONSTRAINT fk_stripe_academyLocation_id
  FOREIGN KEY (academyLocationId)
  REFERENCES academy_location (id)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
END IF;

SET @ItemsMaxId=(select id from standard_master where tableName = 'stripe');
UPDATE standard_master_items SET fieldLabel = 'ACADEMY_LOCATION'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'academyLocation');
UPDATE standard_master_items SET fieldLabel = 'PUBLIC_KEY'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'publicKey');
UPDATE standard_master_items SET fieldLabel = 'SECRET_KEY'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'secretKey');
UPDATE standard_master_items SET fieldLabel = 'ENVIRONMENT'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'environment');
UPDATE standard_master_items SET fieldLabel = 'CURRENCY_CODE'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'currencyCode');
UPDATE standard_master_items SET whetherForeignKey = b'1', fkTable = 'academy_location', fkFieldName = 'id', fkDisplayField = 'academyLocationName'  WHERE (standardMasterId =  @ItemsMaxId and dbFieldName = 'academyLocation') ;


END $$
CALL V20241009171902__Alter_Stripe() $$
DROP PROCEDURE IF EXISTS V20241009171902__Alter_Stripe $$
DELIMITER ;