DELIMITER $$
DROP PROCEDURE IF EXISTS V20241010110906__Update_SQL_For_Thesis_Management $$
CREATE PROCEDURE V20241010110906__Update_SQL_For_Thesis_Management()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='EVENT_STUDENT_NOMINATED_RECIPIENTS')) THEN 
SET @residenceRCPNT=(select id from dtprovider d WHERE d.dataProviderName='EVENT_STUDENT_NOMINATED_RECIPIENTS' limit 1);
UPDATE sql_dtprovider
SET 
    sqlQuery = 'SELECT DISTINCT
    
            T3.userId AS ID,
            T4.printName AS STUDENT_NAME,
            T4.firstName AS FIRST_NAME,
        	T8.emailId AS EMAIL_ID,
            T8.mobileNumber AS MOBILE_NO,
            T8.mobileCountryCode AS MOBILE_CODE,
        	T1.remarks AS REMARKS,
            T7.academyName AS ACADEMY_NAME,
            group_concat(T6.printName) as SUPERVISOR_NAME,
        T9.externalSysRefOne AS SU_NUMBER,
            T10.salutationName AS STUDENT_SALUTATION,
            concat(T11.programcode," ","/"," ",T11.programName) AS PROGRAM_CODE_NAME,
            T2.code AS ADMISSION_ID,
            (
                SELECT GROUP_CONCAT(sal.salutationName,"."," ",p.printName ORDER BY p.printName ASC SEPARATOR \', \')
                FROM thesis_management tm
                left join thesis_management_supervisor tms on tm.id=tms.thesisManagementId
                LEFT JOIN users u ON tms.supervisorId = u.id
                LEFT JOIN staffs s ON u.id = s.userId
                LEFT JOIN persons p ON s.personId = p.id
                LEFT JOIN salutations sal on p.salutationId=sal.id
                WHERE tm.id = T1.id
            ) AS SUPERVISORS,
            concat(T19.salutationName,"."," ",T16.printName) AS NOMINATOR,
            DATE_FORMAT(T1.lastUpdate, \'%d/%m/%Y\') AS NOMINATED_DATE
        FROM
            thesis_management T1
                LEFT JOIN
            admission T2 ON T1.admissionId = T2.id
                LEFT JOIN
            students T3 ON T2.studentId = T3.userId
                LEFT JOIN
            users T4 ON T3.userId = T4.id
                LEFT JOIN
            thesis_management_supervisor T5 ON  T1.id = T5.thesisManagementId
        		LEFT JOIN
            users T6 ON T6.id = T5.supervisorId
                LEFT JOIN
            academy_location T7 ON T7.id = T2.academyLocationId
                   LEFT JOIN
               persons T8 ON T8.id = T3.personId
        LEFT JOIN
            persons T9 on T3.personId=T9.id
        		LEFT JOIN
            salutations T10 on T9.salutationId=T10.id
        		LEFT JOIN
            programs T11 on T2.programId=T11.id
        		LEFT JOIN
            users T16 on T1.lastUpdatedBy=T16.id
        		LEFT JOIN 
            staffs T17 ON T16.id = T17.userId
        		LEFT JOIN
        	persons T18 on T17.personId=T18.id
        		LEFT JOIN 
            salutations T19 on T18.salutationId=T19.id
        
        WHERE T1.status=\'NOMINATED\' AND T3.userId in (namedParams) 
        AND FIND_IN_SET(T6.id,concat(T5.supervisorId)) GROUP BY T5.thesisManagementId order by T5.lastUpdate desc limit 1 '
WHERE
dataProviderId=@residenceRCPNT;
END IF; 

IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='EVENT_STUDENT_NOMINATION_CANCELLED_RECIPIENTS')) THEN 
SET @residenceRCPNT=(select id from dtprovider d WHERE d.dataProviderName='EVENT_STUDENT_NOMINATION_CANCELLED_RECIPIENTS' limit 1);
UPDATE sql_dtprovider 
SET 
    sqlQuery = 'SELECT DISTINCT
             T3.userId AS ID,
            T4.printName AS STUDENT_NAME,
            T4.firstName AS FIRST_NAME,
            T5.remarks AS CANCELLATION_REMARKS,
            T7.emailId AS EMAIL_ID,
            T7.mobileNumber AS MOBILE_NO,
            T7.mobileCountryCode AS MOBILE_CODE,
            T6.academyName AS ACADEMY_NAME,
        T9.externalSysRefOne AS SU_NUMBER,
            T10.salutationName AS STUDENT_SALUTATION,
            concat(T11.programcode," ","/"," ",T11.programName) AS PROGRAM_CODE_NAME,
            T2.code AS ADMISSION_ID,
            (
                SELECT GROUP_CONCAT(sal.salutationName,"."," ",p.printName ORDER BY p.printName ASC SEPARATOR \', \')
                FROM thesis_management tm
                left join thesis_management_supervisor tms on tm.id=tms.thesisManagementId
                LEFT JOIN users u ON tms.supervisorId = u.id
                LEFT JOIN staffs s ON u.id = s.userId
                LEFT JOIN persons p ON s.personId = p.id
                LEFT JOIN salutations sal on p.salutationId=sal.id
                WHERE tm.id = T1.id
            ) AS SUPERVISORS,
            concat(T19.salutationName,"."," ",T16.printName) AS NOMINATOR,
            DATE_FORMAT(T5.lastUpdate, \'%d/%m/%Y\') AS CANCELLATION_DATE
        FROM
            thesis_management T1
                LEFT JOIN
            admission T2 ON T1.admissionId = T2.id
                LEFT JOIN
            students T3 ON T2.studentId = T3.userId
                LEFT JOIN
            users T4 ON T3.userId = T4.id
                LEFT JOIN
            thesis_management_status T5 ON  T1.id = T5.thesisManagementId
        		LEFT JOIN
            academy_location T6 ON T6.id = T2.academyLocationId
            LEFT JOIN
               persons T7 ON T7.id = T3.personId
              LEFT JOIN
        persons T9 on T3.personId=T9.id
        		LEFT JOIN
            salutations T10 on T9.salutationId=T10.id
        		LEFT JOIN
            programs T11 on T2.programId=T11.id
        		LEFT JOIN
            users T16 on T5.lastUpdatedBy=T16.id
    			LEFT JOIN 
        staffs T17 ON T16.id = T17.userId
    		LEFT JOIN
    	persons T18 on T17.personId=T18.id
    		LEFT JOIN 
        salutations T19 on T18.salutationId=T19.id
        WHERE T5.status=\'CANCELLED\' AND T3.userId in (namedParams) order by T5.lastUpdate desc limit 1'
WHERE
dataProviderId=@residenceRCPNT;
END IF; 

IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='THESIS_SUBMISSION_RECIPIENTS')) THEN 
SET @residenceRCPNT=(select id from dtprovider d WHERE d.dataProviderName='THESIS_SUBMISSION_RECIPIENTS' limit 1);
UPDATE sql_dtprovider 
SET 
    sqlQuery = 'SELECT DISTINCT
            T5.id AS ID,
            T6.firstName AS FIRST_NAME,
            T6.printName AS SUPERVISOR_NAME,
        	T6.emailId AS EMAIL_ID,
            T6.mobileNumber AS MOBILE_NO,
            T6.mobileCountryCode AS MOBILE_CODE,
        	T8.remarks AS REMARKS,
        	T4.printName AS STUDENT_NAME,
            T7.academyName AS ACADEMY_NAME,
        T9.externalSysRefOne AS SU_NUMBER,
            T10.salutationName AS STUDENT_SALUTATION,
            concat(T11.programcode," ","/"," ",T11.programName) AS PROGRAM_CODE_NAME,
            T2.code AS ADMISSION_ID,
            (
                SELECT GROUP_CONCAT(sal.salutationName," ",p.printName ORDER BY p.printName ASC SEPARATOR \', \')
                FROM thesis_management tm
                left join thesis_management_supervisor tms on tm.id=tms.thesisManagementId
                LEFT JOIN users u ON tms.supervisorId = u.id
                LEFT JOIN staffs s ON u.id = s.userId
                LEFT JOIN persons p ON s.personId = p.id
                LEFT JOIN salutations sal on p.salutationId=sal.id
                WHERE tm.id = T1.id
            ) AS SUPERVISORS,
             concat(T19.salutationName,"."," ",T16.printName) AS NOMINATOR,
            DATE_FORMAT(T1.lastUpdate, \'%d/%m/%Y\') AS SUBMISSION_DATE
        FROM
            thesis_management T1
                LEFT JOIN
            admission T2 ON T1.admissionId = T2.id
                LEFT JOIN
            students T3 ON T2.studentId = T3.userId
                LEFT JOIN
            users AS T4 ON T4.id = T3.userId
                LEFT JOIN
            thesis_management_supervisor T5 ON  T1.id = T5.thesisManagementId
        		LEFT JOIN
            staffs T20 ON T20.userId = T5.supervisorId
                LEFT JOIN
            persons T6 ON T6.id = T20.personId
                LEFT JOIN
            academy_location T7 ON T7.id = T2.academyLocationId
             LEFT JOIN
            thesis_management_status T8 on T8.thesisManagementId=T1.id
                LEFT JOIN
            persons T9 on T3.personId=T9.id
        		LEFT JOIN
            salutations T10 on T9.salutationId=T10.id
        		LEFT JOIN
            programs T11 on T2.programId=T11.id
        		LEFT JOIN
            users T16 on T1.lastUpdatedBy=T16.id
                LEFT JOIN 
        staffs T17 ON T16.id = T17.userId
    		LEFT JOIN
    	persons T18 on T17.personId=T18.id
    		LEFT JOIN 
        salutations T19 on T18.salutationId=T19.id
        WHERE T8.status=\'SUBMITTED\' AND T5.id in (namedParams) group by T1.id'
WHERE
dataProviderId=@residenceRCPNT;
END IF;

IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='THESIS_REJECTION_RECIPIENTS')) THEN 
SET @residenceRCPNT=(select id from dtprovider d WHERE d.dataProviderName='THESIS_REJECTION_RECIPIENTS' limit 1);
UPDATE sql_dtprovider 
SET 
    sqlQuery = 'SELECT DISTINCT
             T3.userId AS ID,
            T4.printName AS STUDENT_NAME,
            T4.firstName AS FIRST_NAME,
        	T8.emailId AS EMAIL_ID,
            T8.mobileNumber AS MOBILE_NO,
            T8.mobileCountryCode AS MOBILE_CODE,
        	T5.remarks AS REMARKS,
            T7.academyName AS ACADEMY_NAME,
        T9.externalSysRefOne AS SU_NUMBER,
            T10.salutationName AS STUDENT_SALUTATION,
            concat(T11.programcode," ","/"," ",T11.programName) AS PROGRAM_CODE_NAME,
            T2.code AS ADMISSION_ID,
            (
                SELECT GROUP_CONCAT(sal.salutationName,"."," ",p.printName ORDER BY p.printName ASC SEPARATOR \', \')
                FROM thesis_management tm
                left join thesis_management_supervisor tms on tm.id=tms.thesisManagementId
                LEFT JOIN users u ON tms.supervisorId = u.id
                LEFT JOIN staffs s ON u.id = s.userId
                LEFT JOIN persons p ON s.personId = p.id
                LEFT JOIN salutations sal on p.salutationId=sal.id
                WHERE tm.id = T1.id
            ) AS SUPERVISORS,
            concat(T19.salutationName,"."," ",T16.printName) AS NOMINATOR,
            DATE_FORMAT(T5.lastUpdate, \'%d/%m/%Y\') AS REJECTION_DATE
        FROM
            thesis_management T1
                LEFT JOIN
            admission T2 ON T1.admissionId = T2.id
                LEFT JOIN
            students T3 ON T2.studentId = T3.userId
                LEFT JOIN
            users T4 ON T3.userId = T4.id
                LEFT JOIN
            thesis_management_status T5 ON  T1.id = T5.thesisManagementId
        		LEFT JOIN
            academy_location T7 ON T7.id = T2.academyLocationId
            	LEFT JOIN
               persons T8 ON T8.id = T3.personId
        LEFT JOIN
            persons T9 on T3.personId=T9.id
            		LEFT JOIN
                salutations T10 on T9.salutationId=T10.id
            		LEFT JOIN
                programs T11 on T2.programId=T11.id
            		LEFT JOIN
                users T16 on T5.lastUpdatedBy=T16.id
        			LEFT JOIN 
            staffs T17 ON T16.id = T17.userId
        		LEFT JOIN
        	persons T18 on T17.personId=T18.id
        		LEFT JOIN 
            salutations T19 on T18.salutationId=T19.id
        WHERE T5.status=\'REJECTED\' AND T3.userId in (namedParams) order by T5.lastUpdate desc limit 1 '
WHERE
dataProviderId=@residenceRCPNT;
END IF;

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20241010110906__Update_SQL_For_Thesis_Management () $$
DROP PROCEDURE IF EXISTS V20241010110906__Update_SQL_For_Thesis_Management $$
DELIMITER ;