DELIMITER $$
DROP PROCEDURE IF EXISTS d2l4Templates $$
CREATE PROCEDURE d2l4Templates()
BEGIN
SELECT
'type', 'action', 'code', 'name', 'start_date', 'end_date', 'is_active', 'department_code', 'template_code', 'semester_code', 'offering_code', 'custom_code'
 UNION
SELECT
'course template', 'UPDATE', courses.courseCode, courses.nameToBePrinted, '', '', 1,concat(al.academyCode,'-',al.locationCode), '', '', '', concat(al.academyCode,'-',al.locationCode)
FROM program_batch_course_param AS param
JOIN course_variants AS cv ON param.courseVarientId=cv.id
JOIN prog_batch_period_config as period ON param.progBatchPeriodConfigId=period.id
join batches on period.programBatchId=batches.id
JOIN academic_term ON period.academicTermId=academic_term.id AND academic_term.whetherCurrentAcademicTerm=true
join courses on cv.courseId=courses.id
join academy_location as al on cv.academyLocationId= al.id;
END $$ 
DELIMITER ;