DELIMITER $$
DROP PROCEDURE IF EXISTS V20241204114255__Alter_StudentInsuranceTable $$
CREATE PROCEDURE V20241204114255__Alter_StudentInsuranceTable()
BEGIN

IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_insurance_details')) THEN 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'student_insurance_details' AND COLUMN_NAME = 'validFrom')) THEN 
ALTER TABLE student_insurance_details
ADD COLUMN `validFrom`  DATE NULL AFTER `schoolInsuranceType`;
END IF;
IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'student_insurance_details' AND COLUMN_NAME = 'validTo')) THEN 
ALTER TABLE student_insurance_details
ADD COLUMN `validTo`  DATE NULL AFTER `validFrom`;
END IF;
IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'student_insurance_details' AND COLUMN_NAME = 'nameOfInsuranceCompany')) THEN 
ALTER TABLE student_insurance_details
ADD COLUMN `nameOfInsuranceCompany` VARCHAR(255) DEFAULT NULL  AFTER `validTo`;
END IF;
IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'student_insurance_details' AND COLUMN_NAME = 'policyNumber')) THEN 
ALTER TABLE student_insurance_details
ADD COLUMN `policyNumber` VARCHAR(255) DEFAULT NULL AFTER `nameOfInsuranceCompany`;
END IF;
IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'student_insurance_details' AND COLUMN_NAME = 'schoolInsuranceCardReceived')) THEN 
ALTER TABLE student_insurance_details
ADD COLUMN `schoolInsuranceCardReceived` BIT(1) NOT NULL DEFAULT b'1' AFTER `policyNumber`;
END IF;
IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'student_insurance_details' AND COLUMN_NAME = 'receivedDate')) THEN 
ALTER TABLE student_insurance_details
ADD COLUMN `receivedDate`  DATE NULL  AFTER `schoolInsuranceCardReceived`;
END IF;
IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'student_insurance_details' AND COLUMN_NAME = 'remarks')) THEN 
ALTER TABLE student_insurance_details
ADD COLUMN `remarks` VARCHAR(255) DEFAULT NULL AFTER `receivedDate`;
END IF;

END IF; 
END $$
CALL V20241204114255__Alter_StudentInsuranceTable() $$
DROP PROCEDURE IF EXISTS V20241204114255__Alter_StudentInsuranceTable $$
DELIMITER ;