DELIMITER $$
DROP PROCEDURE IF EXISTS V20250113155649__Create_xeroOauthDetails $$
CREATE PROCEDURE V20250113155649__Create_xeroOauthDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='xero_oauth_details')) THEN 
CREATE TABLE `xero_oauth_details` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `locationId` bigint NULL,
  `accessToken` text NOT NULL,
  `refreshToken` text NOT NULL,
  `tokenGenrationTime` datetime NOT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_xero_oauth_details_lastUpdatedBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_xero_oauth_details_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB ;

END IF; 

END $$
CALL V20250113155649__Create_xeroOauthDetails () $$ 
DROP PROCEDURE IF EXISTS V20250113155649__Create_xeroOauthDetails $$ 
DELIMITER ;