DELIMITER $$
DROP PROCEDURE IF EXISTS V20250122145503__Create_dublinDescriptorCSM $$
CREATE PROCEDURE V20250122145503__Create_dublinDescriptorCSM()
BEGIN

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'DUBLIN_DESCRIPTORS')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'dublin_descriptors_csm','DUBLIN_DESCRIPTORS','Program & Courses','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;



SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'PROGRAM_TYPE')) THEN
INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'programPhase', 'PROGRAM_TYPE', @standardMasterMaxId+1, 'Varchar', '1', b'1', 'program_phase', 'id', 'value', b'0', b'0', b'0', '1', now());
END IF;


SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'DUBLIN_DESCRIPTORS_NAME')) THEN
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `maxLength`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'dublinDescriptorsName', 'DUBLIN_DESCRIPTORS_NAME', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '100', '1', now());
END IF;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'DUBLIN_DESCRIPTORS_DESCRIPTION')) THEN
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `maxLength`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'dublinDescriptorsDescription', 'DUBLIN_DESCRIPTORS_DESCRIPTION', @standardMasterMaxId+1, 'TextArea', '3', 0, 0, 0, 1, '512', '1', now());
END IF;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'STATUS')) THEN
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`,`emunType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
 VALUES (@ItemsMaxId + 1, 'dublinDescriptorsActiveInactiveEnum', 'STATUS', @standardMasterMaxId+1, 'Enum','DUBLIN_DESCRIPTORS_ACTIVE_INACTIVE','4',false, 0, 0, 0, '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'DUBLIN_DESCRIPTORS')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('masterNames', 'DUBLIN_DESCRIPTORS', 'Dublin Descriptors', 'Dublin Descriptors','Dublin-beskrywings','Mô tả Dublin',now(),1);
	END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'PROGRAM_TYPE')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('TRANSLATIONS', 'PROGRAM_TYPE', 'Program Type', 'Program Type','Program Tipe','Loại chương trình',now(),1);
	END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'DUBLIN_DESCRIPTORS_NAME')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('TRANSLATIONS', 'DUBLIN_DESCRIPTORS_NAME', 'Dublin Descriptors Name', 'Dublin Descriptors Name','Dublin Beskrywings Naam','Dublin Mô tả Tên',now(),1);
	END IF;


IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'DUBLIN_DESCRIPTORS_DESCRIPTION')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('TRANSLATIONS', 'DUBLIN_DESCRIPTORS_DESCRIPTION', 'Dublin Descriptors Description', 'Dublin Descriptors Description','Dublin Beskrywings Beskrywing','Dublin Descriptors Mô tả',now(),1);
	END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'STATUS')) THEN 
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
	VALUES ('TRANSLATIONS', 'STATUS', 'Status', 'Status','Status','Trạng thái',now(),1);
	END IF; 


END $$
CALL V20250122145503__Create_dublinDescriptorCSM () $$ 
DROP PROCEDURE IF EXISTS V20250122145503__Create_dublinDescriptorCSM $$ 
DELIMITER ;