DELIMITER $$
DROP PROCEDURE IF EXISTS V20250127143308__Update_costcentreTranslation $$
CREATE PROCEDURE V20250127143308__Update_costcentreTranslation()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from ui_translation where keyName="ISCONTROLACCOUNT" and objectName="TRANSLATIONS")) THEN 
update ui_translation
set defaultValue="Is Control Account?" , customerDefineValue="Is Control Account?"
where keyName="ISCONTROLACCOUNT" and objectName="TRANSLATIONS";
END IF; 

SET @standardMasterMaxId=(SELECT id FROM standard_master where tableName='cost_centre' and masterName='COST_CENTRE');

IF EXISTS ((select * from standard_master_items where dbFieldName="costCenters" and fieldLabel="CONTROL_ACCOUNT" and standardMasterId=@standardMasterMaxId)) THEN 
update standard_master_items
set fieldLabel="MAP_COST_CENTRE"
where dbFieldName="costCenters" and fieldLabel="CONTROL_ACCOUNT" and standardMasterId=@standardMasterMaxId;
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='MAP_COST_CENTRE' AND objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','MAP_COST_CENTRE','Map Cost Centre','Map Cost Centre',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='CONTROL_ACCOUNT' AND objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','CONTROL_ACCOUNT','Control Account','Control Account',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE dbFieldName="controlAccount" AND fieldLabel='CONTROL_ACCOUNT' AND standardMasterId=@standardMasterMaxId)) THEN 
INSERT INTO `standard_master_items` (`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`) 
VALUES ('controlAccount','CONTROL_ACCOUNT', @standardMasterMaxId, 'Varchar', '5', 1, 'cost_centre', 'id', 'value', 0, 0, 0, '1');
END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250127143308__Update_costcentreTranslation () $$
DROP PROCEDURE IF EXISTS V20250127143308__Update_costcentreTranslation $$
DELIMITER ;