DELIMITER $$
DROP PROCEDURE IF EXISTS V20250221160750__Insert_NegativeIncidentDFR $$
CREATE PROCEDURE V20250221160750__Insert_NegativeIncidentDFR()
BEGIN

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'negativeincidentform' and  formFieldName ='type')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`
,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('negativeincidentform','type','typeOfIncidentCombo','nestedJsonCombo',1,1,NULL,1,now(),'Type of Incident','1','Negative Incidents',
'Create, Edit, and View','Type of Incident',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'negativeincidentform' and  formFieldName ='incidentDate')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`
,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('negativeincidentform','incidentDate','incidentDate','datefield',1,1,NULL,1,now(),'Date of Incident','1','Negative Incidents',
'Create, Edit, and View','Date of Incident',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'negativeincidentform' and  formFieldName ='incidentRating')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`
,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('negativeincidentform','incidentRating','incidentRating','nestedJsonCombo',0,0,NULL,1,now(),'Rating','1','Negative Incidents',
'Create, Edit, and View','Rating',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'negativeincidentform' and  formFieldName ='reportedBy')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`
,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('negativeincidentform','reportedBy','reportedByField','customcombobox',1,1,NULL,1,now(),'Reported By','1','Negative Incidents',
'Create, Edit, and View','Reported By',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'negativeincidentform' and  formFieldName ='reportedByUserId')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`
,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('negativeincidentform','reportedByUserId','reportedByUserIdField','customcombobox',1,1,NULL,1,now(),'Reporter ID','1','Negative Incidents',
'Create, Edit, and View','Reporter ID',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'negativeincidentform' and  formFieldName ='reportedByUserName')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`
,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('negativeincidentform','reportedByUserName','reportedByUserNameField','textfield',1,1,NULL,1,now(),'Reporter Name','1','Negative Incidents',
'Create, Edit, and View','Reporter Name',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'negativeincidentform' and  formFieldName ='dateOfAction')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`
,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('negativeincidentform','dateOfAction','dateOfAction','datefield',1,0,NULL,1,now(),'Date of Action','1','Negative Incidents',
'Create, Edit, and View','Date of Action',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'negativeincidentform' and  formFieldName ='actionTaken')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`
,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('negativeincidentform','actionTaken','actionTaken','textfield',1,0,NULL,1,now(),'Action Taken','1','Negative Incidents',
'Create, Edit, and View','Action Taken',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'negativeincidentform' and  formFieldName ='outcome')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`
,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('negativeincidentform','outcome','outcomeId','nestedJsonCombo',0,0,NULL,1,now(),'Outcome','1','Negative Incidents',
'Create, Edit, and View','Outcome',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'negativeincidentform' and  formFieldName ='penalty')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`
,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('negativeincidentform','penalty','penaltyId','nestedJsonCombo',0,0,NULL,1,now(),'Penalty','1','Negative Incidents',
'Create, Edit, and View','Penalty',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'negativeincidentform' and  formFieldName ='courseVarient')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`
,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('negativeincidentform','courseVarient','courseVarientId','nestedJsonCombo',0,0,NULL,1,now(),'Course Varient/Name','1','Negative Incidents',
'Create, Edit, and View','Course Varient/Name',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'negativeincidentform' and  formFieldName ='assessmentEvent')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`
,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('negativeincidentform','assessmentEvent','assessmentEventId','nestedJsonCombo',0,0,NULL,1,now(),'Assessment Event','1','Negative Incidents',
'Create, Edit, and View','Assessment Event',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'negativeincidentform' and  formFieldName ='incidentDetails')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`
,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('negativeincidentform','incidentDetails','incidentDetails','textareafield',0,0,NULL,1,now(),'Incident Details','1','Negative Incidents',
'Create, Edit, and View','Incident Details',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'negativeincidentform' and  formFieldName ='remarks')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`
,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('negativeincidentform','remarks','remarks','textareafield',0,0,NULL,1,now(),'Remark','1','Negative Incidents',
'Create, Edit, and View','Remark',0);
END IF;

END $$
CALL V20250221160750__Insert_NegativeIncidentDFR() $$
DROP PROCEDURE IF EXISTS V20250221160750__Insert_NegativeIncidentDFR $$
DELIMITER ;