DELIMITER $$

DROP PROCEDURE IF EXISTS fetchApplicantToStudentConversion $$

CREATE PROCEDURE fetchApplicantToStudentConversion()
BEGIN
 SELECT 
    func_inc_var_session_rec() AS id,
    xum.id AS xeroUserMappingId,
    xum.xeroContactId AS xeroContactId,
    xum.academyLocationId AS academyLocationId,
    usr.code AS userCode,
    usr.id AS userId,
    app.id AS academiaApplicationId
FROM
    xero_user_mapping AS xum
        JOIN
    application AS app ON xum.academiaApplicationId = app.id
        JOIN
    application_program AS appProg ON (appProg.applicationId = app.id
        AND appProg.academyLocationId = xum.academyLocationId)
        JOIN
    admission AS ad ON ad.applicationProgramId = appProg.id
        JOIN
    users AS usr ON usr.id = ad.studentId
WHERE
    xum.academiaUserId IS NULL;
END $$

DELIMITER ;
