DELIMITER $$
DROP PROCEDURE IF EXISTS V20250324183246__Create_Aditya_Birla_Child_Grid $$
CREATE PROCEDURE V20250324183246__Create_Aditya_Birla_Child_Grid()
BEGIN

SET SQL_SAFE_UPDATES = 0;
    
    IF NOT EXISTS (SELECT 1 FROM information_schema.Tables WHERE table_schema = DATABASE() AND table_name = 'aditya_birla_payment_gateway') THEN
        CREATE TABLE `aditya_birla_payment_gateway` (
            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
            `academyLocationId` BIGINT(20) NOT NULL,
             `merchantID` VARCHAR(1000),
            `iv` VARCHAR(1000),
            `adityaBirlaKey` VARCHAR(1000),
            `environment` VARCHAR(1000),
            `currencyCode` VARCHAR(1000),
            `accountIfsc` VARCHAR(1000),
            `accountNo` VARCHAR(1000),
			`whetherActive` BIT (1) DEFAULT b'0',
            `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            `lastUpdatedBy` BIGINT(20) NOT NULL,
            PRIMARY KEY (`id`),
            INDEX `fk_academylocationid_idx` (`academyLocationId` ASC),
            INDEX `fk_aditya_birla_payment_gateway_child_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
            CONSTRAINT `fk_aditya_birla_payment_gateway_academylocationid`
                FOREIGN KEY (`academyLocationId`)
                REFERENCES `academy_location` (`id`)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT,
            CONSTRAINT `fk_aditya_birla_payment_gateway_lastUpdatedBy_user_id`
                FOREIGN KEY (`lastUpdatedBy`)
                REFERENCES `users` (`id`)
                ON DELETE RESTRICT
                ON UPDATE RESTRICT
        );
    END IF;

    IF NOT EXISTS (SELECT 1 FROM standard_master WHERE tableName = 'aditya_birla_payment_gateway' LIMIT 1) THEN
        SET @standardMasterMaxId = (SELECT COALESCE(MAX(id)) FROM standard_master);
       
        INSERT INTO `standard_master`(`id`, `tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`)
        VALUES (@standardMasterMaxId + 1, 'aditya_birla_payment_gateway', 'Aditya Birla', 'Payment Gateway', 'MASTER_WITH_AL', 1, 0, 1, SYSDATE());
    END IF;

    SET @standardMasterId = (SELECT id FROM standard_master WHERE `tableName` = 'aditya_birla_payment_gateway' order by  id desc limit 1);

    IF @standardMasterId IS NOT NULL THEN
        UPDATE `standard_master` SET `childMaster` = @standardMasterId, `whetherParent` = 1 WHERE `tableName` = 'standard_payment_gateway';

        IF NOT EXISTS (SELECT 1 FROM standard_payment_gateway WHERE itemValue = 'Aditya Birla') THEN
            INSERT INTO standard_payment_gateway (itemCode, itemValue, activeStatus, lastUpdate, lastUpdatedBy)  
            VALUES (@standardMasterId, 'Aditya Birla', false, NOW(), 1);
        END IF;

        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'academyLocation' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('academyLocation', 'ACADEMY_LOCATION', @standardMasterId, 'Varchar', 1, 1, 'academy_location', 'id', 'academyLocationName', 0, 0, 0, 1, SYSDATE());
        END IF;

        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'merchantID' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('merchantID', 'MERCHANT_ID', @standardMasterId, 'Varchar', 2, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;

        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'iv' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('iv', 'IV', @standardMasterId, 'Varchar', 3, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;

        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'adityaBirlaKey' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('adityaBirlaKey', 'ADITYA_BIRLA_KEY', @standardMasterId, 'Varchar', 4, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
        
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'environment' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('environment', 'ENVIRONMENT', @standardMasterId, 'Varchar', 5, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
        
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'currencyCode' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('currencyCode', 'CURRENCY_CODE', @standardMasterId, 'Varchar', 6, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
        
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'accountIfsc' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('accountIfsc', 'ACCOUNT_IFSC', @standardMasterId, 'Varchar', 7, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
        
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'accountNo' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
            VALUES ('accountNo', 'ACCOUNT_NO', @standardMasterId, 'Varchar', 8, 0, 0, 0, 0, 1, SYSDATE(),1000);
        END IF;
        
        IF NOT EXISTS (SELECT 1 FROM `standard_master_items` WHERE dbFieldName = 'whetherActive' AND standardMasterId = @standardMasterId) THEN
            INSERT INTO `standard_master_items`(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
            VALUES ('whetherActive', 'WHETHER_ACTIVE', @standardMasterId, 'Boolean', 9, 0, 0, 0, 1, 1, SYSDATE());
        END IF;
    
    END IF;
    SET SQL_SAFE_UPDATES = 1;
END $$ 

CALL V20250324183246__Create_Aditya_Birla_Child_Grid () $$ 
DROP PROCEDURE IF EXISTS V20250324183246__Create_Aditya_Birla_Child_Grid $$ 
DELIMITER ;