DELIMITER $$
DROP PROCEDURE IF EXISTS V20250429174520__Create_ProgressionPanelExamEvent $$

CREATE PROCEDURE V20250429174520__Create_ProgressionPanelExamEvent()
BEGIN

IF NOT EXISTS (
  SELECT * FROM information_schema.tables 
  WHERE table_schema = DATABASE() AND table_name = 'progression_panel_exam_event'
) THEN

CREATE TABLE `progression_panel_exam_event` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `progressionPanelDecisionId` BIGINT NOT NULL,
  `academicTermId` BIGINT NOT NULL,
  `progressionStatusId` BIGINT NULL DEFAULT NULL,
  `sendStatus` BIT NOT NULL DEFAULT b'0',
  `subjectLine` VARCHAR(255),
  `systemGeneratedMsgContent` BLOB,
  `userGeneratedMsgContent` BLOB,
  `ramark` TEXT,
  `progressionStatusCode` VARCHAR(100),
  `marksheetJobId` BIGINT,
  `marksheetPath` TEXT,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  
  PRIMARY KEY (`id`),
  INDEX `fk_progression_panel_exam_event_progressionPanelDecisionId_idx` (`progressionPanelDecisionId` ASC),
  INDEX `fk__progression_panel_exam_event_academicTermId_idx` (`academicTermId` ASC),
  INDEX `fk__progression_panel_exam_event_progressionStatusId_idx` (`progressionStatusId` ASC),
  INDEX `fk_progression_panel_exam_event_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
  INDEX `fk_progression_panel_exam_event_marksheetJobId_idx` (`marksheetJobId` ASC),

  CONSTRAINT `fk_progression_panel_exam_event_progressionPanelDecisionId`
    FOREIGN KEY (`progressionPanelDecisionId`)
    REFERENCES `progression_panel_decision_template` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,

  CONSTRAINT `fk_progression_panel_exam_event_academicTermId`
    FOREIGN KEY (`academicTermId`)
    REFERENCES `academic_term` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,

  CONSTRAINT `fk_progression_panel_exam_event_progressionStatusId`
    FOREIGN KEY (`progressionStatusId`)
    REFERENCES `progression_status` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,

  CONSTRAINT `fk_progression_panel_exam_event_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION,
    
    CONSTRAINT `fk_progression_panel_exam_event_marksheetJobId`
    FOREIGN KEY (`marksheetJobId`)
    REFERENCES `marksheet_job_details` (`id`)
    ON DELETE NO ACTION ON UPDATE NO ACTION
) ;

END IF;

END $$

CALL V20250429174520__Create_ProgressionPanelExamEvent() $$
DROP PROCEDURE IF EXISTS V20250429174520__Create_ProgressionPanelExamEvent $$
DELIMITER ;
