DELIMITER $$
DROP PROCEDURE IF EXISTS V20250502184541__Update_ProgressionPanelExamEvents $$
CREATE PROCEDURE V20250502184541__Update_ProgressionPanelExamEvents()
BEGIN
SET SQL_SAFE_UPDATES = 0;

  -- Proceed
  IF EXISTS (SELECT 1 FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_PROCEED_STATUS_RECIPIENT') THEN
    SET @dtProviderId = (SELECT id FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_PROCEED_STATUS_RECIPIENT');

    UPDATE sql_dtprovider 
    SET sqlQuery = "
      SELECT 
         examEvent.id AS ID,
         person.firstName AS FIRST_NAME,
         person.printName AS STUDENT_PRINT_NAME,
         person.lastName AS LAST_NAME,
         person.emailId AS EMAIL_ID,
         user.code AS STUDENT_ID,
         program.programNameToBePrint AS PROGRAM_NAME,
         batch.printName AS BATCH_NAME,
         period.printName AS PERIOD_NAME,
         location.academyName AS ACADEMY_NAME,
         location.locationName AS LOCATION_NAME,
         prStatus.itemCode AS PROGRESSION_STATUS,
         NOW() AS PRINT_DATETIME,
         marksheetJob.id AS JOB_ID,
         panel.remarks AS REMARK,
         'userGeneratedMsgContent' AS USER_GENERATED_MSG_CONTENT

      FROM
         progression_panel_exam_event examEvent
         INNER JOIN progression_panel_decision_template panel ON panel.id = examEvent.progressionPanelDecisionId
         INNER JOIN progression_status prStatus ON panel.decisionId = prStatus.id
         INNER JOIN marksheet_job_details marksheetJob ON marksheetJob.id = examEvent.marksheetJobId
         INNER JOIN admission adm ON adm.id = panel.admissionId AND adm.studentId = panel.studentId
         INNER JOIN users user ON user.id = adm.studentId
         INNER JOIN students student ON student.userId = user.id
         INNER JOIN persons person ON person.id = student.personId
         INNER JOIN academy_location location ON location.id = adm.academyLocationId
         INNER JOIN prog_batch_period_config period ON period.id = panel.periodId
         INNER JOIN batches batch ON batch.id = period.programBatchId
         INNER JOIN programs program ON program.id = batch.programId
      WHERE
         examEvent.id IN (namedParams)
      LIMIT 1"
    WHERE dataProviderId = @dtProviderId;
  END IF;

  IF EXISTS (SELECT 1 FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_PROCEED_STATUS_DL') THEN
    SET @dtProviderId = (SELECT id FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_PROCEED_STATUS_DL');

    UPDATE sql_dtprovider 
    SET sqlQuery = "
      SELECT T1.id AS USER_ID 
      FROM progression_panel_exam_event T1 
      WHERE T1.id IN (namedParams);"
    WHERE dataProviderId = @dtProviderId;
  END IF;


-- Proceed with condition 
  IF EXISTS (SELECT 1 FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_PROCEED_WITH_CONDITION_STATUS_RECIPIENT') THEN
    SET @dtProviderId = (SELECT id FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_PROCEED_WITH_CONDITION_STATUS_RECIPIENT');

    UPDATE sql_dtprovider 
    SET sqlQuery = "
      SELECT 
       examEvent.id AS ID,
       person.firstName AS FIRST_NAME,
       person.printName AS STUDENT_PRINT_NAME,
       person.lastName AS LAST_NAME,
	   person.emailId AS EMAIL_ID,
	   user.code AS STUDENT_ID,
	   program.programNameToBePrint AS PROGRAM_NAME,
       batch.printName AS BATCH_NAME,
	   period.printName AS PERIOD_NAME,
       location.academyName AS ACADEMY_NAME,
       location.locationName AS LOCATION_NAME,
       prStatus.itemCode as PROGRESSION_STATUS,
	   course.courseCode AS COURSE_CODE,
       course.courseName AS COURSE_NAME,
	   now() as PRINT_DATETIME,
	   marksheetJob.id as JOB_ID,
	   panel.remarks as REMARK,
       'userGeneratedMsgContent' AS USER_GENERATED_MSG_CONTENT
       
 FROM
 progression_panel_exam_event examEvent
           inner join 
		   progression_panel_decision_template panel on panel.id=examEvent.progressionPanelDecisionId
           inner join 
		   progression_status prStatus on panel.decisionId=prStatus.id
           inner join 
           marksheet_job_details marksheetJob on marksheetJob.id=examEvent.marksheetJobId
		   inner join 
           admission  adm on adm.id=panel.admissionId and adm.studentId=panel.studentId
	       inner join
		   users  user on user.id=adm.studentId
           inner join
		   students student on student.userId=user.id  
		   inner join
		   persons  person on person.id=student.personId
		   inner join 
		   academy_location location on location.id=adm.academyLocationId
		   inner join 
		   prog_batch_period_config period on period.id=panel.periodId
		   inner join
		   batches batch on batch.id=period.programBatchId
	       inner join 
		   programs program on program.id=batch.programId
           inner join 
           evaluation_plan_rank planRank on planRank.admissionId=panel.admissionId and planRank.periodId=panel.periodId
           inner join 
           course_variants cv on cv.id=planRank.courseVariantId 
           inner join 
           courses course on course.id=cv.courseId
   WHERE
       examEvent.id IN (namedParams)  and  planRank.status='FAIL'
      group by course.id "
    WHERE dataProviderId = @dtProviderId;
  END IF;

  IF EXISTS (SELECT 1 FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_PROCEED_WITH_CONDITION_STATUS_DL') THEN
    SET @dtProviderId = (SELECT id FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_PROCEED_WITH_CONDITION_STATUS_DL');

    UPDATE sql_dtprovider 
    SET sqlQuery = "
      SELECT T1.id as USER_ID FROM
        	 `progression_panel_exam_event` T1 
		      WHERE T1.id IN (namedParams);"
    WHERE dataProviderId = @dtProviderId;
  END IF;

-- RESIT 
IF EXISTS (SELECT 1 FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_RESIT_STATUS_RECIPIENT') THEN
    SET @dtProviderId = (SELECT id FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_RESIT_STATUS_RECIPIENT');

    UPDATE sql_dtprovider 
    SET sqlQuery = "
       SELECT 
       examEvent.id AS ID,
       person.firstName AS FIRST_NAME,
       person.printName AS STUDENT_PRINT_NAME,
       person.lastName AS LAST_NAME,
	   person.emailId AS EMAIL_ID,
	   user.code AS STUDENT_ID,
	   program.programNameToBePrint AS PROGRAM_NAME,
       batch.printName AS BATCH_NAME,
	   period.printName AS PERIOD_NAME,
       location.academyName AS ACADEMY_NAME,
       location.locationName AS LOCATION_NAME,
       prStatus.itemCode as PROGRESSION_STATUS,
	   course.courseCode AS COURSE_CODE,
       course.courseName AS COURSE_NAME,
	   now() as PRINT_DATETIME,
	   marksheetJob.id as JOB_ID,
	   panel.remarks as REMARK,
       DATE_FORMAT(eventDetail.conductedDate, '%Y-%m-%d') AS ASSESSMENT_DATE,
       DATE_FORMAT(eventDetail.time, '%H:%i') AS CONDUCTED_TIME,
       'userGeneratedMsgContent' AS USER_GENERATED_MSG_CONTENT

FROM
 progression_panel_exam_event examEvent
           inner join 
		   progression_panel_decision_template panel on panel.id=examEvent.progressionPanelDecisionId
           inner join 
		   progression_status prStatus on panel.decisionId=prStatus.id
           inner join 
           marksheet_job_details marksheetJob on marksheetJob.id=examEvent.marksheetJobId
		   inner join 
           admission  adm on adm.id=panel.admissionId and adm.studentId=panel.studentId
	       inner join
		   users  user on user.id=adm.studentId
           inner join
		   students student on student.userId=user.id  
		   inner join
		   persons  person on person.id=student.personId
		   inner join 
		   academy_location location on location.id=adm.academyLocationId
		   inner join 
		   prog_batch_period_config period on period.id=panel.periodId
		   inner join
		   batches batch on batch.id=period.programBatchId
	       inner join 
		   programs program on program.id=batch.programId
           inner join 
           evaluation_plan_rank planRank on planRank.admissionId=panel.admissionId and planRank.periodId=panel.periodId
           inner join 
           course_variants cv on cv.id=planRank.courseVariantId 
           inner join 
           courses course on course.id=cv.courseId
		   inner join 
		   examination_result result  ON result.admissionId = panel.admissionId  AND result.periodId = panel.periodId    
		   AND result.courseVariantId = planRank.courseVariantId
           inner join 
           evaluation_type_course typeCourse   ON typeCourse.periodId = result.periodId   AND typeCourse.courseVariantId = result.courseVariantId  
           inner join 
           exam_event_detail eventDetail   ON eventDetail.eventId = result.evaluationDetailSequenceId AND typeCourse.id = eventDetail.evaluationTypeCourseId  
           inner join 
           eval_seq_detail mainEvent ON mainEvent.id = eventDetail.eventId 
   WHERE
           examEvent.id IN (namedParams) 
           and  planRank.status='FAIL'
           and mainEvent.whetherDetailSeqEquivalent is true
           group by course.id"
    WHERE dataProviderId = @dtProviderId;
  END IF;

  IF EXISTS (SELECT 1 FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_RESIT_STATUS_DL') THEN
    SET @dtProviderId = (SELECT id FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_RESIT_STATUS_DL');

    UPDATE sql_dtprovider 
    SET sqlQuery = "
    SELECT T1.id as USER_ID FROM
        	 `progression_panel_exam_event` T1 
		      WHERE T1.id IN (namedParams);"
    WHERE dataProviderId = @dtProviderId;
  END IF;

-- RETAKE
 IF EXISTS (SELECT 1 FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_RECIPIENT') THEN
    SET @dtProviderId = (SELECT id FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_RECIPIENT');

    UPDATE sql_dtprovider 
    SET sqlQuery = "
      SELECT 
       examEvent.id AS ID,
       person.firstName AS FIRST_NAME,
       person.printName AS STUDENT_PRINT_NAME,
       person.lastName AS LAST_NAME,
	   person.emailId AS EMAIL_ID,
	   user.code AS STUDENT_ID,
	   program.programNameToBePrint AS PROGRAM_NAME,
       batch.printName AS BATCH_NAME,
	   period.printName AS PERIOD_NAME,
       location.academyName AS ACADEMY_NAME,
       location.locationName AS LOCATION_NAME,
       prStatus.itemCode as PROGRESSION_STATUS,
	   course.courseCode AS COURSE_CODE,
       course.courseName AS COURSE_NAME,
	   now() as PRINT_DATETIME,
	   marksheetJob.id as JOB_ID,
	   panel.remarks as REMARK,
       'userGeneratedMsgContent' AS USER_GENERATED_MSG_CONTENT
       
 FROM
 progression_panel_exam_event examEvent
           inner join 
		   progression_panel_decision_template panel on panel.id=examEvent.progressionPanelDecisionId
           inner join 
		   progression_status prStatus on panel.decisionId=prStatus.id
           inner join 
           marksheet_job_details marksheetJob on marksheetJob.id=examEvent.marksheetJobId
		   inner join 
           admission  adm on adm.id=panel.admissionId and adm.studentId=panel.studentId
	       inner join
		   users  user on user.id=adm.studentId
           inner join
		   students student on student.userId=user.id  
		   inner join
		   persons  person on person.id=student.personId
		   inner join 
		   academy_location location on location.id=adm.academyLocationId
		   inner join 
		   prog_batch_period_config period on period.id=panel.periodId
		   inner join
		   batches batch on batch.id=period.programBatchId
	       inner join 
		   programs program on program.id=batch.programId
           inner join 
           evaluation_plan_rank planRank on planRank.admissionId=panel.admissionId and planRank.periodId=panel.periodId
           inner join 
           course_variants cv on cv.id=planRank.courseVariantId 
           inner join 
           courses course on course.id=cv.courseId
   WHERE
       examEvent.id IN (namedParams)  and  planRank.status='FAIL'
      group by course.id "
    WHERE dataProviderId = @dtProviderId;
  END IF;

  IF EXISTS (SELECT 1 FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_DL') THEN
    SET @dtProviderId = (SELECT id FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_RETAKE_SEMESTER_STATUS_DL');

    UPDATE sql_dtprovider 
    SET sqlQuery = "
      SELECT T1.id as USER_ID FROM
        	 `progression_panel_exam_event` T1 
		      WHERE T1.id IN (namedParams);"
    WHERE dataProviderId = @dtProviderId;
  END IF;

-- FAIL 


IF EXISTS (SELECT 1 FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_ACADEMIC_FAILURE_STATUS_RECIPIENT') THEN
    SET @dtProviderId = (SELECT id FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_ACADEMIC_FAILURE_STATUS_RECIPIENT');

    UPDATE sql_dtprovider 
    SET sqlQuery = "
      SELECT 
       examEvent.id AS ID,
       person.firstName AS FIRST_NAME,
       person.printName AS STUDENT_PRINT_NAME,
       person.lastName AS LAST_NAME,
	   person.emailId AS EMAIL_ID,
	   user.code AS STUDENT_ID,
	   program.programNameToBePrint AS PROGRAM_NAME,
       batch.printName AS BATCH_NAME,
	   period.printName AS PERIOD_NAME,
       location.academyName AS ACADEMY_NAME,
       location.locationName AS LOCATION_NAME,
       prStatus.itemCode as PROGRESSION_STATUS,
	   course.courseCode AS COURSE_CODE,
       course.courseName AS COURSE_NAME,
	   now() as PRINT_DATETIME,
	   marksheetJob.id as JOB_ID,
	   panel.remarks as REMARK,
       'userGeneratedMsgContent' AS USER_GENERATED_MSG_CONTENT
       
 FROM
 progression_panel_exam_event examEvent
           inner join 
		   progression_panel_decision_template panel on panel.id=examEvent.progressionPanelDecisionId
           inner join 
		   progression_status prStatus on panel.decisionId=prStatus.id
           inner join 
           marksheet_job_details marksheetJob on marksheetJob.id=examEvent.marksheetJobId
		   inner join 
           admission  adm on adm.id=panel.admissionId and adm.studentId=panel.studentId
	       inner join
		   users  user on user.id=adm.studentId
           inner join
		   students student on student.userId=user.id  
		   inner join
		   persons  person on person.id=student.personId
		   inner join 
		   academy_location location on location.id=adm.academyLocationId
		   inner join 
		   prog_batch_period_config period on period.id=panel.periodId
		   inner join
		   batches batch on batch.id=period.programBatchId
	       inner join 
		   programs program on program.id=batch.programId
           inner join 
           evaluation_plan_rank planRank on planRank.admissionId=panel.admissionId and planRank.periodId=panel.periodId
           inner join 
           course_variants cv on cv.id=planRank.courseVariantId 
           inner join 
           courses course on course.id=cv.courseId
   WHERE
       examEvent.id IN (namedParams)  and  planRank.status='FAIL'
      group by course.id "
    WHERE dataProviderId = @dtProviderId;
  END IF;

  IF EXISTS (SELECT 1 FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_ACADEMIC_FAILURE_STATUS_DL') THEN
    SET @dtProviderId = (SELECT id FROM dtprovider WHERE dataProviderName = 'EMAIL_MARKSHEET_FOR_ACADEMIC_FAILURE_STATUS_DL');

    UPDATE sql_dtprovider 
    SET sqlQuery = "
      SELECT T1.id as USER_ID FROM
        	 `progression_panel_exam_event` T1 
		      WHERE T1.id IN (namedParams);"
    WHERE dataProviderId = @dtProviderId;
  END IF;

  SET SQL_SAFE_UPDATES = 1;
END $$
CALL V20250502184541__Update_ProgressionPanelExamEvents () $$
DROP PROCEDURE IF EXISTS V20250502184541__Update_ProgressionPanelExamEvents $$
DELIMITER ;