DELIMITER $$
DROP PROCEDURE IF EXISTS V20250509125651__Create_VGUReceiptWithSettlementReport $$
CREATE PROCEDURE V20250509125651__Create_VGUReceiptWithSettlementReport()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Receipt With Settlement');

IF NOT EXISTS ((SELECT * FROM `report_template` where `reportTypeId`=@reportTypeTempId and `templateCode`='MANAGE_RECEIPT_SETTLEMENT_CODE' and `templateName`='VGU - Receipt with settlement')) THEN
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES (@reportTypeTempId, 'MANAGE_RECEIPT_SETTLEMENT_CODE', 'VGU - Receipt With Settlement', 'VGUReceiptwithsettlement.png', 'CommonReport_VGU_RECEIPT_WITH_SETTLEMENT.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'VGU_RECEIPT_WITH_SETTLEMENT.jasper', 'AcademiaLogo.png');
END IF;

set @temp = (select max(id) from report_template where templateCode ='MANAGE_RECEIPT_SETTLEMENT_CODE');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @temp and keyValue='TRANS_RECEIPTNO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_RECEIPTNO', 'Receipt No', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @temp and keyValue='TRANS_COLLAGER_COPY')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_COLLAGER_COPY', 'College Copy', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @temp and keyValue='TRANS_STUDENT_COPY')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_STUDENT_COPY', 'Student Copy', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_DATE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_DATE', 'Date', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_RECEIVED_FROM')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_RECEIVED_FROM', 'Received From', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_FATHER_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_FATHER_NAME', 'Father Name', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_ID')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_ID', 'Id', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_NATIONALID')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_NATIONALID', 'National ID / Passport NO.', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_ACADEMY_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_ACADEMY_NAME', 'Academy Name', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_PROGRAM_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_PROGRAM_NAME', 'Program Name', '1', NOW()); 
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_PROCESSED_BY')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_PROCESSED_BY', 'Processed By', '1', NOW()); 
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_SR_NO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_SR_NO', 'Sr. No.', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_PARTICULAR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_PARTICULAR', 'Particular', '1', NOW()); 
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_AMOUNT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_AMOUNT', 'Amount', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_AMOUNT_FEES')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_AMOUNT_FEES', 'Total Fees', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_CHEQUE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_CHEQUE', 'Cheque/Card/DD/OnlineTxn No.', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_DATED')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_DATED', 'Dated', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_INVOICE_NO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_INVOICE_NO', 'Invoice Number', '1', NOW()); 
END IF; 


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_BANK_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_BANK_NAME', 'Bank Name', '1', NOW()); 
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_REMARK')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_REMARK', 'Remark', '1', NOW()); 
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_CASHIER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_CASHIER', 'Cashier', '1', NOW()); 
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_SIGNATURE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_SIGNATURE', 'Signature of Depositor', '1', NOW()); 
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @temp  and keyValue='TRANS_HEAD_OF_FINANCE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@temp, 'TRANS_HEAD_OF_FINANCE', 'Head of Finance and Accounting Department', '1', NOW()); 
END IF; 

END $$
CALL V20250509125651__Create_VGUReceiptWithSettlementReport () $$ 
DROP PROCEDURE IF EXISTS V20250509125651__Create_VGUReceiptWithSettlementReport $$ 
DELIMITER ;