DELIMITER $$
DROP PROCEDURE IF EXISTS V20250513162822__Create_AttestationStatementPeriodListDP $$
CREATE PROCEDURE V20250513162822__Create_AttestationStatementPeriodListDP()
BEGIN

IF EXISTS (SELECT id FROM dydt_data_provider WHERE providerName = 'Inactive Admission Data Providers') THEN
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId = (SELECT dataProviderId FROM `dydt_data_line_item` where dataSourceCode='INACTIVE_ADMISSION_DATA_PROVIDERS');
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`
, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'ATTESTATION_STATEMENT_PERIOD_LIST', '5',null, '1', '0', 
"SELECT 
    pbpc.printName AS APP_SEMESTER,
    dd.value AS APP_LOCATION,
    CASE
        WHEN journy.resultStatus IN ('Completed' , 'Enrolled', 'Pre-Enrolled') THEN ''
        ELSE journy.resultStatus
    END AS APP_REMARK,
    CONCAT('From ',
            DATE_FORMAT(pbpc.programPeriodStart, '%d.%m.%Y'),
            ' to ',
            DATE_FORMAT(pbpc.programPeriodEnd, '%d.%m.%Y')) APP_DATES
FROM
    student_journey journy
        JOIN
    prog_batch_period_config pbpc ON pbpc.id = journy.periodId
        LEFT JOIN
    academy_location_campus locampus ON locampus.id = journy.academyCampusId
        LEFT JOIN
    drop_down dd ON dd.id = locampus.campusId", 'PRM_ADMISSION_ID', 
	'APP_SEMESTER,APP_LOCATION,APP_REMARK,APP_DATES',
'where admissionId=PRM_ADMISSION_ID', '1');

SET @dataLineItemId = (SELECT id FROM dydt_data_line_item WHERE dataSourceCode = 'ATTESTATION_STATEMENT_PERIOD_LIST');

IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dataLineItemId AND translationCode = 'APP_REMARK') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('APP_REMARK', 'Remark', @dataLineItemId);
END IF;
IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dataLineItemId AND translationCode = 'APP_LOCATION') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('APP_LOCATION', 'Location', @dataLineItemId);
END IF;
IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dataLineItemId AND translationCode = 'APP_SEMESTER') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('APP_SEMESTER', 'Semester', @dataLineItemId);
END IF;
IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dataLineItemId AND translationCode = 'APP_DATES') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('APP_DATES', 'Dates', @dataLineItemId);
END IF;
IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dataLineItemId AND translationCode = 'ATTESTATION_STATEMENT_PERIOD_LIST') THEN
     INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId) VALUES ('ATTESTATION_STATEMENT_PERIOD_LIST', 'Attestation Statement Period List', @dataLineItemId);
END IF;

END IF;

END $$
CALL V20250513162822__Create_AttestationStatementPeriodListDP () $$ 
DROP PROCEDURE IF EXISTS V20250513162822__Create_AttestationStatementPeriodListDP $$ 
DELIMITER ;