DELIMITER $$
DROP PROCEDURE IF EXISTS V20250609112854__Create_registrationConfirmOnPeriodEnroll $$
CREATE PROCEDURE V20250609112854__Create_registrationConfirmOnPeriodEnroll()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT')) THEN 

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='PROGRAM_AND_COURSE');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT'); 

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT');

INSERT INTO `system_msg_event` (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT', 'Registration Confirmation on Period Enrollment', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Registration Confirmation on Period Enrollment');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT_RCPNT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT_RCPNT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT_RCPNT');

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT_RCPNT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT DISTINCT
   T2.id AS USER_ID,
    T2.academyLocationId AS ACADEMY_LOCATION_IDS
FROM
    program_batch_students T1
        LEFT OUTER JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT OUTER JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT OUTER JOIN
    batches T4 ON T1.programBatchId = T4.id
        LEFT OUTER JOIN
    programs T5 ON T4.programId = T5.id
        LEFT OUTER JOIN
    prog_batch_period_config T6 ON T1.progBatchPeriodConfigId = T6.id
        LEFT OUTER JOIN
    prog_batch_seat_config T7 on T7.id = T1.progBatchSeatConfigId
WHERE T1.isCurrentPeriod=true AND T1.isCurrentSection=true AND T1.exitDate is null
AND T2.id in(namedParams)",NULL);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT_RCPNT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`,`sqlQuery`, `jsonString`) 
VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT DISTINCT
    T2.id AS ID,
    T17.printName as USERNAME,
    T18.printName AS STUDENT_PRINT_NAME,
    T18.firstName AS FIRST_NAME,
    T18.middleName AS MIDDLE_NAME,
    T18.lastName AS LAST_NAME,
    T18.emailId AS EMAIL_ID,
    T18.alternateEmailId as ALTERNATE_EMAIL_ID,
    T18.mobileNumber AS MOBILE_NO,
    T18.mobileCountryCode AS MOBILE_CODE,
    CONVERT(FROM_BASE64(T17.passwordBase64) USING utf8) AS PASSWORD,
    T5.programNameToBePrint AS PROGRAM_NAME,
    T4.printName AS INTAKE_NAME,
    T6.printName AS PERIOD_NAME,
    T17.code AS STUDENT_ID, 
    T15.itemValue AS ACADEMIC_TERM, 
    T16.itemValue AS INTAKE_YEAR,
    T7.academyName AS ACADEMY_NAME,
    T7.locationName AS LOCATION_NAME,
    T7.displayName AS ACADEMY_LOCATION,
    T14.seatName as SEAT_TYPE,
    CONCAT(T9.phoneCountryCode,'-',T9.phoneAreaCode,'-',T9.phoneNo) AS CAMPUS_PHONE_NO,
    T9.primaryeEmailId AS CAMPUS_EMAILID,
    T9.websiteURL AS CAMPUS_WEBSITE_URL,
    (CASE
        WHEN
            T7.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T7.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL
FROM
    program_batch_students T1
        LEFT OUTER JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT OUTER JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT OUTER JOIN
    batches T4 ON T1.programBatchId = T4.id
        LEFT OUTER JOIN
    programs T5 ON T4.programId = T5.id
        LEFT OUTER JOIN
    prog_batch_period_config T6 ON T1.progBatchPeriodConfigId = T6.id
        LEFT OUTER JOIN
    academy_location T7 on T7.id = T5.academyLocationId
        LEFT OUTER JOIN
    academy_location_addresses ala on ala.academyLocationId = T7.id
        LEFT OUTER JOIN
    address T9 ON T9.id = ala.addressId 
        LEFT OUTER JOIN
    city T10 ON T10.id = T9.cityId
        LEFT OUTER JOIN
    country T11 ON T11.id = T10.countryId
        LEFT OUTER JOIN
    country_region T12 ON T12.id = T10.countryRegionId
        LEFT OUTER JOIN
    prog_batch_seat_config T13 on T13.id = T1.progBatchSeatConfigId
        LEFT OUTER JOIN
    seat_types T14 on T14.id = T13.seatTypeId
        LEFT OUTER JOIN
    academic_term T15 on T15.id = T6.academicTermId
        LEFT OUTER JOIN
    intake_year T16 on T16.id = T4.intakeYearId
        LEFT OUTER JOIN
    users T17 on T17.id = T3.userId
        LEFT OUTER JOIN
    persons T18 on T18.id = T3.personId
     LEFT OUTER JOIN    
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE T1.isCurrentPeriod=true AND T1.isCurrentSection=true AND T1.exitDate is null
AND T2.id in (namedParams) group by T3.userId",'{
 "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "programNameToBePrint",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "displayName",
            "resultKey": "ACADEMY_LOCATION",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "campusPhoneNo",
            "resultKey": "CAMPUS_PHONE_NO",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "campusEmailId",
            "resultKey": "CAMPUS_EMAILID",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "campusWebsiteUrl",
            "resultKey": "CAMPUS_WEBSITE_URL",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "seatName",
            "resultKey": "SEAT_TYPE",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "printName",
            "resultKey": "USERNAME",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "printName",
            "resultKey": "INTAKE_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "printName",
            "resultKey": "PERIOD_NAME",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "Password",
            "resultKey": "PASSWORD",
            "displayCode": "",
            "displayOrder": 17
        },
		{
            "id": 19,
            "value": "itemValue",
            "resultKey": "ACADEMIC_TERM",
            "displayCode": "",
            "displayOrder": 18
        },
		{
            "id": 20,
            "value": "itemValue",
            "resultKey": "INTAKE_YEAR",
            "displayCode": "",
            "displayOrder": 19
        }
    ]}');


SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT_RCPNT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`) 
VALUES(@msgtemplateconfigId+1,'Registration Confirmation on Period Enrollment',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,4,NULL,NULL,'Registration Confirmation on Period Enrollment',NULL,'',NULL,'','APPROVED','','1','System Admin','1','English');

INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateconfigId+1,'1','Registration Confirmation on Period Enrollment','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; height:120px;">
            <td align="center" style="margin:0px;"><img height="120" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
        </tr>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			 <p align="left"> $recipientData[&quot;STUDENT_ID&quot;] </p>
			 <p align="left">Dear $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;] </p>
			 <p align="left">Congratulations, you are now registered with The IIE&#180;s $recipientData[&quot;ACADEMY_LOCATION&quot;] for the $recipientData[&quot;PROGRAM_NAME&quot;] for $recipientData[&quot;ACADEMIC_TERM&quot;]. Your Student Number is $recipientData[&quot;STUDENT_ID&quot;] and your confirmation of registration letter is attached to this email.</p>
			 <p align="left">To view the details of your registration, please log into your student portal using the log-in credentials previously provided.</p>
			 <p align="left">URL: https://stasy.tertiary.iie.edu.za/ </p>
			 <p align="left">Please remember where post-registration conditions are applicable, these must be satisfied by the required due date.</p>
			 <p align="left">Please contact your campus if you have any questions regarding your registration.</p>
			 <p align="left">We wish you well as you embark on your academic journey with us.</p>
			</td>
		</tr>
		<tr style="background-color:#f0f0f0; line-height:12px;">
            <td style="padding:0px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Kind regards,<br/><br/>The IIE&#180;s $recipientData[&quot;ACADEMY_LOCATION&quot;]</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Email Address: $recipientData[&quot;CAMPUS_EMAILID&quot;]</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Phone Number: $recipientData[&quot;CAMPUS_PHONE_NO&quot;] <br/><br/>Website: $recipientData[&quot;CAMPUS_WEBSITE_URL&quot;]</p>
            </td>
        </tr>
		<tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" /></td>
        </tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateconfigId+1,'2','NULL','Dear $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;] Congratulations, you are now registered with The IIEs $recipientData[&quot;ACADEMY_LOCATION&quot;] for the $recipientData[&quot;PROGRAM_NAME&quot;] for $recipientData[&quot;ACADEMIC_TERM&quot;]. Your Student Number is $recipientData[&quot;STUDENT_ID&quot;] . Kind Regards, ');

INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateconfigId+1,'4','Registration Confirmation on Period Enrollment','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; height:120px;">
            <td align="center" style="margin:0px;"><img height="120" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
        </tr>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			 <p align="left"> $recipientData[&quot;STUDENT_ID&quot;] </p>
			 <p align="left">Dear $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;] </p>
			 <p align="left">Congratulations, you are now registered with The IIE&#180;s $recipientData[&quot;ACADEMY_LOCATION&quot;] for the $recipientData[&quot;PROGRAM_NAME&quot;] for $recipientData[&quot;ACADEMIC_TERM&quot;]. Your Student Number is $recipientData[&quot;STUDENT_ID&quot;] and your confirmation of registration letter is attached to this email.</p>
			 <p align="left">To view the details of your registration, please log into your student portal using the log-in credentials previously provided.</p>
			 <p align="left">URL: https://stasy.tertiary.iie.edu.za/ </p>
			 <p align="left">Please remember where post-registration conditions are applicable, these must be satisfied by the required due date.</p>
			 <p align="left">Please contact your campus if you have any questions regarding your registration.</p>
			 <p align="left">We wish you well as you embark on your academic journey with us.</p>
			</td>
		</tr>
		<tr style="background-color:#f0f0f0; line-height:12px;">
            <td style="padding:0px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Kind regards,<br/><br/>The IIE&#180;s $recipientData[&quot;ACADEMY_LOCATION&quot;]</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Email Address: $recipientData[&quot;CAMPUS_EMAILID&quot;]</p>
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:14px">Phone Number: $recipientData[&quot;CAMPUS_PHONE_NO&quot;] <br/><br/>Website: $recipientData[&quot;CAMPUS_WEBSITE_URL&quot;]</p>
            </td>
        </tr>
		<tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" /></td>
        </tr>
	</tbody>
</table>
</body>
</html>');


-- Start :  setting of dynamic document

SET @dydtdocumenttypeId=(SELECT MAX(id) FROM `dydt_document_type`);
INSERT INTO `dydt_document_type` (`id`,`typeName`, `configLevelCode`, `whetherDeletable`, `typeCode`, `availableForAdhoc`, `whetherEditable`) 
VALUES (@dydtdocumenttypeId+1,'Registration Confirmation on Period Enrollment', 'ACADEMY_LOCATION_LEVEL', '0', 'Registration Confirmation on Period Enrollment', '0', '1');

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @sysmsgevtrcpntdocId=(SELECT MAX(id) FROM `sys_msg_evt_rcpnt_doc`);
SET @msgscopeparamId=(select id from msg_scope_param where paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_rcpnt_doc`(`id`,`sysMsgEvtRcpntDefaultConfigId`,`docTypeId`,`docGenOwnerMappingDef`,`docGenParamMapDef`)
VALUES(@sysmsgevtrcpntdocId+1,@sysmsgevtrcptdefaultconfId,@dydtdocumenttypeId+1,@msgscopeparamId,'[{"MSG_PARAM":"CONTEXT_RECORD_ID","DOC_GEN_PARAM":"PRM_STUDENT_ID"}]');

-- Start : Mapping of Dynamic Document to MsgTemplate

SET @msgtemplateconfigdocId=(SELECT MAX(id) FROM `msg_template_config_doc`);
INSERT INTO `msg_template_config_doc` (`id`,`msgTemplateconfigId`, `sysMsgEvtRcpntdocId`) VALUES (@msgtemplateconfigdocId+1,@msgtemplateconfigId+1,@sysmsgevtrcpntdocId+1);

-- End : Mapping of Dynamic Document to Msgtemplate

SET @dydtdataproviderId=(SELECT MAX(id) FROM `dydt_data_provider`);
INSERT INTO `dydt_data_provider` (`id`,`providerName`, `priority`) VALUES (@dydtdataproviderId+1,'Registration Confirmation on Period Enrollment', '1');

SET @dydtdocumentdataproviderId=(SELECT MAX(id) FROM `dydt_document_data_provider`);
INSERT INTO `dydt_document_data_provider` (`id`,`dataProviderId`, `documentTypeId`) VALUES (@dydtdocumentdataproviderId+1,@dydtdataproviderId+1, @dydtdocumenttypeId+1);

-- COMPLETE_ADMISSION_INPUT_PARAMETER this is first data provider for document gen

SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, 
`sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) 
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId+1, 'REGISTRATION_CONFIRMATION_ON_PERIOD_ENROLLMENT_INFO', '1',null,'1', '1', 
'SELECT DISTINCT
    T3.userId AS ID,
    T17.printName AS APP_USERNAME,
    T18.firstName AS APP_FIRST_NAME,
    T18.middleName AS APP_MIDDLE_NAME,
    T18.lastName AS APP_LAST_NAME,
    g.itemValue AS APP_GENDER,
    T18.emailId AS APP_EMAIL_ID,
    T18.alternateEmailId AS APP_ALTERNATE_EMAIL_ID,
    T18.birthDate AS APP_DATE_OF_BIRTH,
    T18.alternateMobileNo AS APP_ALTERNATE_MO_NO,
    T18.mobileNumber AS APP_MOBILE_NO,
    T18.mobileCountryCode AS APP_MOBILE_CODE,
    CONVERT( FROM_BASE64(T17.passwordBase64) USING UTF8) AS APP_PASSWORD,
    T5.programNameToBePrint AS APP_PROGRAM_NAME,
    T4.printName AS APP_INTAKE_NAME,
    T6.printName AS APP_PERIOD_NAME,
    T17.code AS APP_STUDENT_ID,
    T15.itemValue AS APP_ACADEMIC_TERM,
    T16.itemValue AS APP_INTAKE_YEAR,
    T20.itemValue AS APP_MODE_OF_DELIVERY,
	 if(T4.batchPartTime = TRUE, "Part Time", "Full Time") AS APP_REGISTRATION_TYPE,
    T4.startDate AS APP_INTAKE_START_DATE,
    T4.tillDate AS APP_INTAKE_END_DATE,
    T7.academyName AS APP_ACADEMY_NAME,
    T7.locationName AS APP_LOCATION_NAME,
    T7.displayName AS APP_ACADEMY_LOCATION,
    T14.seatName AS APP_SEAT_TYPE,
    T9.phoneCountryCode AS APP_PHONE_COUNTRY_CODE,
    T9.phoneAreaCode AS APP_PHONE_AREA_CODE,
    T9.phoneNo AS APP_PHONE_NO,
    T9.primaryeEmailId AS APP_CAMPUS_EMAILID,
    addr.websiteURL AS APP_CAMPUS_WEBSITE_URL,
    stdaddr.addressText AS APP_STD_ADDRESS,
    T18.nationalID as APP_NATIONAL_ID,
    T22.idTypeName as APP_ID_TYPE,
    T21.salutationName AS APP_TITLE,
    T39.itemValue AS APP_CAST_CATEGORY,
    T23.itemValue AS APP_NATIONALITY,
    T26.value AS APP_HOME_LANGUAGE,
    T2.admissionDate AS APP_ADMISSION_DATE,
	T29.addressText AS APP_CURRENT_ADDRESS,
    T36.countryName AS APP_COUNTRY_NAME_STUDENT,
    T37.countryRegionName AS APP_COUNTRY_REGION_STUDENT,
    T38.cityName AS APP_CITY_STUDENT,
    T29.pincode AS APP_POSTAL_CODE,
	pt.name AS APP_PAYMENT_TERM,
 T1.requestReceivedDate AS APP_REQUEST_RECEIVED_DATE,
    (select itemValue from student_course_enrollment scen join exam_center_csm eccsm on eccsm.id=scen.examCenterId where scen.examCenterId is not null and scen.admissionId=T2.id and scen.programBatchPeriodConfigId=T6.id order by scen.examCenterId desc limit 1 ) AS APP_EXAM_CENTER,
T18.externalSysRefOne AS SU_NUMBER,
    date(now()) as CURRENT_DATE_
FROM
    program_batch_students T1
        LEFT OUTER JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT OUTER JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT OUTER JOIN
    batches T4 ON T1.programBatchId = T4.id
        LEFT OUTER JOIN
    programs T5 ON T4.programId = T5.id
        LEFT OUTER JOIN
    prog_batch_period_config T6 ON T1.progBatchPeriodConfigId = T6.id
        LEFT OUTER JOIN
    academy_location T7 ON T7.id = T5.academyLocationId
		LEFT OUTER JOIN
	academy_location_addresses ala on ala.academyLocationId = T7.id
		LEFT OUTER JOIN
    address addr ON addr.id = ala.addressId 
        LEFT OUTER JOIN
    locations T19 ON T19.id = T7.locationId
        LEFT OUTER JOIN
    location_addresses T8 ON T8.locationId = T19.id
        LEFT JOIN
    address T9 ON T9.id = T8.addressId
        LEFT OUTER JOIN
    city T10 ON T10.id = T9.cityId
        LEFT OUTER JOIN
    country T11 ON T11.id = T10.countryId
        LEFT OUTER JOIN
    country_region T12 ON T12.id = T10.countryRegionId
        LEFT OUTER JOIN
    prog_batch_seat_config T13 ON T13.id = T1.progBatchSeatConfigId
        LEFT OUTER JOIN
    seat_types T14 ON T14.id = T13.seatTypeId
        LEFT OUTER JOIN
    academic_term T15 ON T15.id = T6.academicTermId
        LEFT OUTER JOIN
    intake_year T16 ON T16.id = T4.intakeYearId
        LEFT OUTER JOIN
    users T17 ON T17.id = T3.userId
        LEFT OUTER JOIN
    persons T18 ON T18.id = T3.personId
   LEFT OUTER JOIN gender g ON g.id = T18.genderId
        LEFT OUTER JOIN
    person_addresses pa ON T18.id = pa.personId
		AND pa.whetherPrimary = TRUE
        LEFT OUTER JOIN
    address stdaddr ON pa.addressId = stdaddr.id
        LEFT JOIN
    mode_of_delivery T20 ON T20.id = T4.modeOfDeliveryId
       LEFT OUTER JOIN 
    caste_categories T39 on T39.id = T18.castCategoryId
       LEFT OUTER JOIN 
	salutations T21 ON T21.id = T18.salutationId
       Left outer join 
    id_type T22 on T22.id= T18.idTypeId
         Left outer join 
    nationalities T23 on T23.id = T18.nationalityId
		 Left outer join 
    drop_down T26 on T26.id = T18.homeLanguage
         LEFT OUTER JOIN 
    person_addresses T27 on T27.personId = T18.id
         LEFT OUTER JOIN 
    address_type T28 on T28.id = T27.addressTypeId and T28.code = "CRNT" and T28.addressCategory = "PERSON"
         LEFT OUTER JOIN 
    address T29 on T29.id = T27.addressId
		 LEFT OUTER JOIN
    city T38 ON T38.id = T29.cityId
         LEFT OUTER JOIN
    country_region T37 ON T37.id = T38.countryRegionId
        LEFT OUTER JOIN
    country T36 ON T36.id = T37.countryId
   left outer join payment_term pt on pt.id = T1.paymentTermId','PRM_STUDENT_ID', 
'APP_USERNAME,APP_FIRST_NAME,APP_MIDDLE_NAME,APP_LAST_NAME,APP_EMAIL_ID,
 APP_MOBILE_NO,APP_MOBILE_CODE,APP_PASSWORD,APP_PROGRAM_NAME,APP_INTAKE_NAME,APP_PERIOD_NAME,APP_STUDENT_ID,
 APP_ACADEMIC_TERM,APP_INTAKE_YEAR,APP_MODE_OF_DELIVERY,APP_REGISTRATION_TYPE,APP_INTAKE_START_DATE,
 APP_INTAKE_END_DATE,APP_ACADEMY_NAME,APP_LOCATION_NAME,APP_ACADEMY_LOCATION,APP_SEAT_TYPE,APP_PHONE_COUNTRY_CODE,APP_PHONE_AREA_CODE,
 APP_PHONE_NO,APP_CAMPUS_EMAILID,APP_CAMPUS_WEBSITE_URL,APP_STD_ADDRESS,APP_NATIONAL_ID,APP_ID_TYPE,APP_TITLE,APP_CAST_CATEGORY,APP_NATIONALITY,
 APP_HOME_LANGUAGE,APP_ADMISSION_DATE,APP_CURRENT_ADDRESS,APP_COUNTRY_NAME_STUDENT,APP_COUNTRY_REGION_STUDENT,APP_CITY_STUDENT,APP_POSTAL_CODE, APP_PAYMENT_TERM,APP_REQUEST_RECEIVED_DATE,APP_EXAM_CENTER,SU_NUMBER,CURRENT_DATE_','WHERE T2.id=PRM_STUDENT_ID AND T1.isCurrentPeriod=true AND T1.isCurrentSection=true AND T1.exitDate is null group by T3.userId', '0');


INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_USERNAME', 'Username',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_FIRST_NAME', 'Student First Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_MIDDLE_NAME', 'Student Middle Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_LAST_NAME', 'Student Last Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_PASSWORD', 'Password',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_EMAIL_ID', 'Email Id',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_MOBILE_NO', 'Mobile No',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_MOBILE_CODE', 'Mobile Code',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_PROGRAM_NAME', 'Program Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_INTAKE_NAME', 'Intake Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_PERIOD_NAME', 'Period Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_STUDENT_ID', 'Student ID',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_ACADEMIC_TERM', 'Academic Term',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_INTAKE_YEAR', 'Intake Year',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_MODE_OF_DELIVERY', 'Mode of Delivery',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_REGISTRATION_TYPE', 'Registration Type',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_INTAKE_START_DATE', 'Intake Start Date',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_INTAKE_END_DATE', 'Intake End Date',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_ACADEMY_NAME', 'Academy Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_LOCATION_NAME', 'Location Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_ACADEMY_LOCATION', 'Academy Location',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_SEAT_TYPE', 'Seat Type',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_PHONE_COUNTRY_CODE', 'Country code',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_PHONE_AREA_CODE', 'Phone Area Code',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_PHONE_NO', 'Phone No',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_CAMPUS_EMAILID', 'Campus Email Id',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_CAMPUS_WEBSITE_URL', 'Website',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APP_STD_ADDRESS', 'Student Address',@dydtdatalinitemId+1);

SET @dydtTemplateconfId=(SELECT MAX(id) FROM `dydt_template_conf`);

END IF; 

END $$
CALL V20250609112854__Create_registrationConfirmOnPeriodEnroll () $$ 
DROP PROCEDURE IF EXISTS V20250609112854__Create_registrationConfirmOnPeriodEnroll $$ 
DELIMITER ;