DELIMITER $$
DROP PROCEDURE IF EXISTS V20250610145525__Create_sponsor_invoice_received_amount $$
CREATE PROCEDURE V20250610145525__Create_sponsor_invoice_received_amount()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='sponsor_invoice_received_amount')) THEN 
CREATE TABLE `sponsor_invoice_received_amount`(
	`id` bigint(20) NOT NULL AUTO_INCREMENT,
	`sponsorInvoiceId` bigint(20) Default Null,
	`receivedDate` bigint(20) Default Null,
	`receivedAmount` varchar(255) Default Null,
	`lastUpdatedBy` bigint(20) NOT NULL,
	`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (id),
	INDEX `fk_sponsor_invoice_received_amount_to_sponsor_invoice__idx`(`sponsorInvoiceId`),
	INDEX `sponsor_invoice_received_amount_to_user_idx` (`lastUpdatedBy`) ,
  
  CONSTRAINT `fk_sponsor_invoice_received_amount_to_sponsor_invoice__idx` 
	FOREIGN KEY (`sponsorInvoiceId`) 
	REFERENCES `sponsor_invoice`(`id`)
    ON DELETE RESTRICT
	ON UPDATE RESTRICT,
 
  CONSTRAINT `sponsor_invoice_received_amount_to_user_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);END IF; 

END $$
CALL V20250610145525__Create_sponsor_invoice_received_amount () $$ 
DROP PROCEDURE IF EXISTS V20250610145525__Create_sponsor_invoice_received_amount $$ 
DELIMITER ;