DELIMITER $$
DROP PROCEDURE IF EXISTS V20250610193904__Create_appliTransCredit $$
CREATE PROCEDURE V20250610193904__Create_appliTransCredit()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_transfer_credit_request')) THEN 
	CREATE TABLE `applicant_transfer_credit_request` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `applicantId` BIGINT NOT NULL,
  `programId` BIGINT NOT NULL,
  `programBatchId` BIGINT NULL,
  `progBatchPeriodConfigId` BIGINT NULL,
  `courseId` BIGINT NULL,
  `equivalenceCourseCode` VARCHAR(100) NULL DEFAULT NULL,
  `equivalenceCourseName` VARCHAR(100) NULL DEFAULT NULL,
  `institueName` VARCHAR(100) NULL DEFAULT NULL,
  `equivalenceCourseCredit` VARCHAR(100) NULL DEFAULT NULL,
  `obtainedMarkGrade` VARCHAR(100) NULL DEFAULT NULL,
  `status` VARCHAR(50) NULL DEFAULT NULL,
  `remark` VARCHAR(255) NULL DEFAULT NULL,
  `documentId` BIGINT NULL DEFAULT NULL,
  `approveBy` BIGINT NULL,
  `approveRejectDate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_trans_credit_program_idx` (`programId` ASC),
  INDEX `fk_trans_credit_batch_idx` (`programBatchId` ASC),
  INDEX `fk_trans_credit_period_idx` (`progBatchPeriodConfigId` ASC),
  INDEX `fk_trans_credit_ap_course_idx` (`courseId` ASC),
  INDEX `fk_trans_credit_ap_document_idx` (`documentId` ASC),
  INDEX `fk_trans_credit_ap_user_idx` (`approveBy` ASC),
  INDEX `fk_trans_credit_ap_lastupdate_idx` (`lastUpdatedBy` ASC),
  INDEX `fk_trans_credit_applicant_idx` (`applicantId` ASC),
  CONSTRAINT `fk_trans_credit_applicant`
    FOREIGN KEY (`applicantId`)
    REFERENCES `application` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_trans_credit_ap_program`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_trans_credit_ap_batch`
    FOREIGN KEY (`programBatchId`)
    REFERENCES `batches` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_trans_credit_ap_period`
    FOREIGN KEY (`progBatchPeriodConfigId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_trans_credit_ap_course`
    FOREIGN KEY (`courseId`)
    REFERENCES `courses` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_trans_credit_ap_document`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_trans_credit_ap_approve`
    FOREIGN KEY (`approveBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_trans_credit_ap_lastupdate`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
 
END IF; 

END $$
CALL V20250610193904__Create_appliTransCredit () $$ 
DROP PROCEDURE IF EXISTS V20250610193904__Create_appliTransCredit $$ 
DELIMITER ;