
-- 1. Drop old version of the procedure (if exists)
DROP PROCEDURE IF EXISTS hesa_studentdetails;

-- 2. Create the updated procedure
DELIMITER $$

CREATE PROCEDURE hesa_studentdetails (
    IN p_academicTermId BIGINT,
    IN p_programId BIGINT
)
BEGIN
	
    SELECT DISTINCT
        adm.id AS NUMHUS,
        gr.itemCode AS SEXID,
        us.code AS SID,
        ddd.name AS DISABILITY,
        adm.admissionDate AS ENGSTARTDATE,
        pcd.awardCertificate AS QUALAWARDID,
        ps.programCode AS QUALID,
        ps.id AS COURSEID,
        pbpc.id AS SCSESSIONID,
        cacc.itemCode AS QUALAWARDACCID,
        cacc.itemCode AS STUACCID,
        mody.itemCode AS SCSMODE,
        pbpc.programPeriodStart AS SCSSTARTDATE,
        fb.itemCode AS FUNDINGBODY,
        pbpc.programPeriodSeq AS RPSTULOAD,
        py.itemCode AS YEAR,
        ss.itemCode AS STATUSCHANGEDTO,
        ss.lastUpdate AS STATUSVALIDFROM,
        al.academyCode AS STUDYLOCID,
        100 AS STUDYPROPORTION,
        stte.supervisorIdentifier AS SUPALLID,
        stte.supervisorProportion AS SUPALLPROP,
        psi.itemCode AS STUINITID,
        01 AS REFPERIOD,
        fst.itemCode AS FINSUPTYPE,
        pbpc.programPeriodStart AS MODINSTSTARTDATE,
        sjd.collaborationAgreementType AS COLPROVTYPEID,
        sjd.partnerNumhus AS PARTNERNUMHUS,
        sjd.partnerSid AS PARTNERSID,
        sjd.partnerUkprn AS PARTNERUKPRN,
        CASE WHEN ei.NSFAS_holder = 1 THEN '01' END AS APELCRD,
        clc.itemCode AS CARELEAVER,
        ddatcd.id AS CRDSCM,
        ddpq.name AS PARED,
        ctry.code AS PERMADDCOUNTRY,
        addr.postalCode AS PERMADDPOSTCODE,
        ebm.itemCode AS PREVIOUSPROVIDER,
        prn.uCASSchemeCode AS UCASSCHEMECODE,
        ca.itemCode AS HIGHESTQOE,
        pccsm.itemCode AS QUALAWARDRESULT,
        stte.title AS THESISTITLE,
        stte.title AS INTENDEDTHESISTITLE,
        py.id AS SESSIONYEARID,
        st.itemCode AS STUDYABROAD,
        eolq.itemCode AS ELQ,
        fc.itemCode AS FUNDCOMP,
        fl.itemCode AS FUNDLENGTH,
        nrff.itemCode AS NONREGFEE,
        pbpc.programPeriodEnd AS MODINSTENDDATE,
        apf.itemCode AS APPSPEND,
        fs.financialSupportAmount AS FINSUPAMOUNT,
        CASE 
            WHEN ps.isLongDistanceProgram = 1 AND al.locationName = 'UK' THEN 1
            WHEN ps.isLongDistanceProgram = 1 AND (al.locationName <> 'UK' OR al.locationName IS NULL) THEN 2
            ELSE NULL
        END AS DISTANCE,
        uoa.itemCode AS REF2021UNITOFASSESSMENT,
        tab.itemCode AS SUPALLHESAID,
        ddwn.name AS SOC2010,
        dddn.name AS SOC2020,
        CASE WHEN ei.NSFAS_holder = 1 THEN '01' END AS SEC
    FROM admission adm
    JOIN program_batch_students pbs ON pbs.admissionId = adm.id AND pbs.isCurrentPeriod = 1 AND pbs.isCurrentSection = 1 AND pbs.exitDate IS NULL
    LEFT JOIN completions c ON c.admissionId = adm.id
    LEFT JOIN students stu ON adm.studentId = stu.userId
    LEFT JOIN persons prn ON prn.id = stu.personId
    LEFT JOIN person_disability pd ON pd.personId = prn.id
    LEFT JOIN drop_down ddd ON ddd.id = pd.haveDisabilityId
    LEFT JOIN student_joint_degree sjd ON sjd.personId = prn.id
    LEFT JOIN users us ON us.id = stu.userId
    LEFT JOIN prog_batch_period_config pbpc ON pbpc.id = pbs.progBatchPeriodConfigId
    LEFT JOIN batches btc ON pbs.programBatchId = btc.id
    LEFT JOIN programs ps ON ps.id = btc.programId
    LEFT JOIN curriculum_accrediation_mapping cam ON cam.programId = ps.id
    LEFT JOIN curriculum_accrediation cacc ON cacc.id = cam.curriculumAccrediationId
    LEFT JOIN gender gr ON prn.genderId = gr.id
    LEFT JOIN person_addresses pad ON prn.id = pad.personId AND pad.whetherDeleted = 0
    LEFT JOIN address addr ON pad.addressId = addr.id
    LEFT JOIN country ctry ON addr.countryId = ctry.id
    LEFT JOIN education_histories eh ON eh.personId = prn.id AND eh.whetherDeleted = 0
    LEFT JOIN result_status rs ON rs.id = eh.resultStatusId
    LEFT JOIN exam_passed ep ON eh.examPassedId = ep.id
    LEFT JOIN service_requests sr ON sr.requester = stu.userId
    LEFT JOIN program_completion_details pcd ON pcd.admissionId = adm.id
    LEFT JOIN mode_of_delivery mody ON btc.modeOfDeliveryId = mody.id
    LEFT JOIN student_course_enrollment sce ON adm.id = sce.admissionId AND pbs.progBatchPeriodConfigId = sce.programBatchPeriodConfigId
    LEFT JOIN course_variants cv ON sce.courseVarientId = cv.id
    LEFT JOIN courses cs ON cs.id = cv.courseId
    LEFT JOIN placement_type pt ON pbpc.placementTypeId = pt.id
    LEFT JOIN placement_campus pc ON pc.placementTypeId = pt.id
    LEFT JOIN activity_duration_type adt ON adt.id = pc.activityDurationTypeId
    LEFT JOIN period_year py ON py.id = pbpc.periodYearId
    LEFT JOIN student_status ss ON ss.id = adm.stdAdmissionStatusId
    LEFT JOIN academy_location al ON al.id = adm.academyLocationId
    LEFT JOIN student_thesis_title stte ON stte.programId = ps.id
    LEFT JOIN program_initiative_mapping pim ON pim.programId = ps.id
    LEFT JOIN program_specific_initiative psi ON psi.id = pim.programSpecificInitiativeId
    LEFT JOIN financial_support fs ON fs.studentId = stu.userId
    LEFT JOIN financial_support_type fst ON fst.id = fs.financialSupportTypeId
    LEFT JOIN care_leaver_csm clc ON clc.id = prn.careLeaverCSMId
    LEFT JOIN add_transfer_credit_details atcd ON atcd.admissionId = adm.id
    LEFT JOIN drop_down ddatcd ON ddatcd.id = atcd.creditTypeId
    LEFT JOIN economic_information ei ON ei.person_Id = prn.id
    LEFT JOIN exam_board_master ebm ON ebm.id = eh.examBoardId
    LEFT JOIN current_activity ca ON ca.id = prn.current_activity_id
    LEFT JOIN program_completion_award_type_csm pccsm ON pccsm.id = pcd.awardTypeId
    LEFT JOIN subject_type st ON st.id = cs.subjectTypeId
    LEFT JOIN funding_and_monitoring fm ON fm.studentId = stu.userId
    LEFT JOIN equivalent_or_lower_qualification eolq ON eolq.id = fm.equivalentOrLowerQualificationId
    LEFT JOIN funding_completion fc ON fc.id = fm.fundingCompletionId
    LEFT JOIN funding_length fl ON fl.id = fm.fundingLengthId
    LEFT JOIN non_regulated_fee_flag nrff ON nrff.id = fm.nonRegulatedFeeFlagId
    LEFT JOIN funding_body fb ON fb.id = fm.fundingBodyId
    LEFT JOIN student_followup sf ON sf.studentId = stu.userId
    LEFT JOIN access_and_participation_flag apf ON fs.accessAndParticipantFlagId = apf.id
    LEFT JOIN academy_location_addresses ala ON ala.addressId = addr.id
    LEFT JOIN unit_of_assessment uoa ON uoa.id = stte.unitOfAssessmentId
    LEFT JOIN thesis_approval_body tab ON tab.id = stte.approvalBody
    LEFT JOIN drop_down ddwn ON ddwn.id = ei.school_fee_per_year
    LEFT JOIN drop_down dddn ON dddn.id = ei.is_scholarship
    LEFT JOIN drop_down ddpq ON ddpq.id = ei.parent_qualification1
    WHERE pbpc.academicTermId = p_academicTermId
      AND ps.id = p_programId
    GROUP BY adm.id;
END $$

DELIMITER ;