DELIMITER $$
DROP PROCEDURE IF EXISTS getSAGECancelledReceiptsData $$
CREATE PROCEDURE `getSAGECancelledReceiptsData` (
    IN academyLocationId BIGINT,
    IN studentCode varchar(25),
    IN cancellationFromDate DATE,
    IN cancellationToDate DATE,
    IN creationFromDate DATE,
    IN creationToDate DATE,
    IN lastUpdatedFromDate DATE,
    IN lastUpdatedToDate DATE
)
BEGIN
    SELECT 
        Date(rh.cancellationDate) AS `reversalDate`,
        rh.receiptNo AS `reference`,
        rh.cancellationNarration AS `description`,
        rh.amount AS `reversalAmount`,
        u.code AS `studentAccountNumber`,
        rh.status AS `status`,
        DATE(rh.creationDateTime) AS `createdDate`,
        DATE(rh.lastUpdate) AS `updatedDate`	
    FROM receipt_header rh
    LEFT JOIN users u ON rh.studentId = u.id
    LEFT JOIN academy_location al ON rh.academyLocationId = al.id
    LEFT JOIN cost_centre cc on rh.costCentreId=cc.id
    WHERE rh.amount > 0 AND rh.status= 'CANCELLED'
      AND (academyLocationId IS NULL OR al.id = academyLocationId)
      AND (studentCode IS NULL OR u.code = studentCode)
      AND (cancellationFromDate IS NULL OR Date(rh.cancellationDate) >= cancellationFromDate)
      AND (cancellationToDate IS NULL OR Date(rh.cancellationDate) <= cancellationToDate)
      AND (creationFromDate IS NULL OR DATE(rh.creationDateTime) >= creationFromDate)
      AND (creationToDate IS NULL OR DATE(rh.creationDateTime) <= creationToDate)
      AND (lastUpdatedFromDate IS NULL OR DATE(rh.lastUpdate) >= lastUpdatedFromDate)
      AND (lastUpdatedToDate IS NULL OR DATE(rh.lastUpdate) <= lastUpdatedToDate)
    GROUP BY rh.id;
END$$

DELIMITER ;