DELIMITER $$
DROP PROCEDURE IF EXISTS V20250627143346__Create_StudentTransferCreditRequest $$
CREATE PROCEDURE V20250627143346__Create_StudentTransferCreditRequest()
BEGIN
IF NOT EXISTS (SELECT * FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name = 'student_transfer_credit_request') THEN
CREATE TABLE `student_transfer_credit_request` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `admissionId` BIGINT NOT NULL,
  `batchId` BIGINT NOT NULL,
  `examTransferType` VARCHAR(30),
  `status` VARCHAR(50) DEFAULT 'PENDING',
  `completionStatus` VARCHAR(50) DEFAULT 'PENDING',
  `requestedDate` DATE NOT NULL,
  `statusUpdateBy` BIGINT(20) NULL,
  `statusUpdateDate` DATE NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,

  PRIMARY KEY (`id`),

  INDEX `fk_student_transfer_credit_request_admission_idx` (`admissionId`),
  INDEX `fk_student_transfer_credit_request_batch_idx` (`batchId`),
  INDEX `fk_student_transfer_credit_request_statusUpdateBy_idx` (`statusUpdateBy`),
  INDEX `fk_student_transfer_credit_request_lastUpdatedBy_idx` (`lastUpdatedBy`),

  CONSTRAINT `fk_student_transfer_credit_request_admission`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
     
  CONSTRAINT `fk_student_transfer_credit_request_batch`
    FOREIGN KEY (`batchId`)
    REFERENCES `batches` (`id`)
    ON DELETE NO ACTION 
    ON UPDATE NO ACTION,
    
  CONSTRAINT `fk_student_transfer_credit_request_statusUpdateBy`
    FOREIGN KEY (`statusUpdateBy`)
    REFERENCES `users` (`id`)
    ON DELETE SET NULL 
    ON UPDATE NO ACTION,

 CONSTRAINT `fk_student_transfer_credit_request_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

END IF; 
END $$
CALL V20250627143346__Create_StudentTransferCreditRequest () $$ 
DROP PROCEDURE IF EXISTS V20250627143346__Create_StudentTransferCreditRequest $$ 
DELIMITER ;