DELIMITER $$
DROP PROCEDURE IF EXISTS V20250701160544__Update_HostelApplicantReminderDaysEvent $$
CREATE PROCEDURE V20250701160544__Update_HostelApplicantReminderDaysEvent()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='DAYS_FOR_SENDING_OFFER_LETTER_RECIPIENTS')) THEN 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAYS_FOR_SENDING_OFFER_LETTER_RECIPIENTS');
update `sql_dtprovider` set `sqlQuery` = "SELECT distinct T1.id AS ID,
   T2.emailId AS EMAIL_ID, T2.printName AS USERNAME, T1.code  AS APPLICATION_ID , T2.printName AS PRINT_NAME, T2.firstName AS FIRST_NAME,
	T2.lastName AS LAST_NAME, T3.itemValue AS ACADEMIC_TERM, 
    DATEDIFF(T5.offerLetterExpiryDate, CURDATE()) AS NOTIFICATION_BEFORE_OFFER_EXPIRES_IN_DAYS
 	FROM  application T1 
     LEFT OUTER JOIN
 	applicant_person T2  ON T1.applicantPersonId=T2.id 
     LEFT OUTER JOIN
 	applicant_hostel_requirement T6 ON T2.id=T6.applicantPersonId 
     LEFT OUTER JOIN
 	applicant_hostel_details T7 ON T6.id=T7.applicantHostelRequirementId 
     LEFT OUTER JOIN
 	hostel_application_setup T4 ON T6.waitingListTypeSetupId=T4.id 
     LEFT OUTER JOIN
 	academic_term T3  ON T4.year=T3.id 
     LEFT OUTER JOIN
 	hostel_offer_detail T5 ON T6.id=T5.applicantHostelRequirementId 
     WHERE T6.applicationStatus ='OFFER_LETTER_ISSUED'  AND  T1.id IN (namedParams)",
      `jsonString` = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "APPLICATION_ID",
            "displayCode": "",
            "displayOrder": 0
        },
		{
            "id": 2,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
		  {
            "id": 3,
            "value": "itemValue",
            "resultKey": "ACADEMIC_TERM",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "offerLetterExpiryDate",
            "resultKey": "NOTIFICATION_BEFORE_OFFER_EXPIRES_IN_DAYS",
            "displayCode": "",
            "displayOrder": 3
        }
  	  ]
	}'
     where `dataProviderId` = @dtproviderId;
END IF; 
SET SQL_SAFE_UPDATES=1;
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='DAYS_FOR_SENDING_OFFER_LETTER_DL')) THEN 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAYS_FOR_SENDING_OFFER_LETTER_DL');
update `sql_dtprovider` set `sqlQuery` = "SELECT DISTINCT 
    T1.id AS USER_ID
FROM 
    application T1 
    LEFT JOIN applicant_person T2 ON T1.applicantPersonId = T2.id 
    LEFT JOIN applicant_hostel_requirement T3 ON T2.id = T3.applicantPersonId 
    LEFT JOIN applicant_hostel_details T4 ON T3.id = T4.applicantHostelRequirementId 
    LEFT JOIN hostel_application_setup T5 ON T3.waitingListTypeSetupId = T5.id 
    LEFT JOIN hostel_offer_detail T6 ON T3.id = T6.applicantHostelRequirementId 
WHERE 
    T3.whetherDeleted = false 
    AND T3.applicationStatus = 'OFFER_LETTER_ISSUED'  
    AND T5.notificationBeforeOfferExpires IS NOT NULL
    AND T3.convertToStudent = false 
    AND CURDATE() BETWEEN DATE_SUB(T6.offerLetterExpiryDate, INTERVAL T5.notificationBeforeOfferExpires DAY)
                      AND T6.offerLetterExpiryDate" where `dataProviderId` = @dtproviderId;
END IF; 
SET SQL_SAFE_UPDATES=1;
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM msg_category WHERE `code`='APPLICANT_DAYS_FOR_SENDING_OFFER_LETTER')) THEN 
set @msgCategoryId = (SELECT id FROM msg_category WHERE `code`='APPLICANT_DAYS_FOR_SENDING_OFFER_LETTER');
UPDATE `msg_category` SET `code` = 'NOTIFICATION_BEFORE_OFFER_EXPIRES_IN_DAYS' WHERE `id` =@msgCategoryId ;
END IF; 

IF EXISTS ((SELECT * FROM system_msg_event WHERE `code`='APPLICANT_DAYS_FOR_SENDING_OFFER_LETTER')) THEN 
set @systemMsgEventId = (SELECT id FROM system_msg_event WHERE `code`='APPLICANT_DAYS_FOR_SENDING_OFFER_LETTER');
UPDATE `system_msg_event` SET `code` = 'NOTIFICATION_BEFORE_OFFER_EXPIRES_IN_DAYS', `displayCode` = 'Applicant - Notification Before Offer Expires (in Days)', 
`description` = 'Applicant - Notification Before Offer Expires (in Days)', `uiDisplayCode` = 'Applicant - Notification Before Offer Expires (in Days)' WHERE `id` = @systemMsgEventId;
END IF; 

IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='DAYS_FOR_SENDING_OFFER_LETTER_DL')) THEN 
set @dtProviderIdDL = (SELECT id FROM dtprovider WHERE `dataProviderName`='DAYS_FOR_SENDING_OFFER_LETTER_DL');
UPDATE `dtprovider` SET `dataProviderName` = 'NOTIFICATION_BEFORE_OFFER_EXPIRES_IN_DAYS_DL' WHERE  id =@dtProviderIdDL;
END IF; 

IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='DAYS_FOR_SENDING_OFFER_LETTER_RECIPIENTS')) THEN 
set @dtProviderIdRC = (SELECT id FROM dtprovider WHERE `dataProviderName`='DAYS_FOR_SENDING_OFFER_LETTER_RECIPIENTS');
UPDATE `dtprovider` SET `dataProviderName` = 'NOTIFICATION_BEFORE_OFFER_EXPIRES_IN_DAYS_RECIPIENTS' WHERE  id =@dtProviderIdRC;
END IF; 

IF EXISTS ((SELECT * FROM msg_recipient_type WHERE `code`='DAYS_FOR_SENDING_OFFER_LETTER_RECIPIENTS')) THEN 
set @recipientTypeId = (SELECT id FROM msg_recipient_type WHERE `code`='DAYS_FOR_SENDING_OFFER_LETTER_RECIPIENTS');
UPDATE `msg_recipient_type` SET `code` = 'NOTIFICATION_BEFORE_OFFER_EXPIRES_IN_DAYS_RECIPIENTS' WHERE `id` =  @recipientTypeId ;
END IF; 

IF EXISTS ((SELECT * FROM msg_template_config WHERE `code`='Days for sending offer letter')) THEN 
set @template_configId = (SELECT id FROM msg_template_config WHERE `code`='Days for sending offer letter');
UPDATE `msg_template_config` SET `code` = 'Notification Before Offer Expires', `templateConfigName` = 'Notification Before Offer Expires' WHERE `id` = @template_configId;
UPDATE `msg_template` SET `subjectLine` = 'Hostel Offer About To Expire' WHERE msgTemplateConfigId  = @template_configId ; 
END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250701160544__Update_HostelApplicantReminderDaysEvent () $$
DROP PROCEDURE IF EXISTS V20250701160544__Update_HostelApplicantReminderDaysEvent $$
DELIMITER ;