DELIMITER $$
DROP PROCEDURE IF EXISTS V20250715185118__Update_DataProviderForOfferLetter $$
CREATE PROCEDURE V20250715185118__Update_DataProviderForOfferLetter()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT max(id) FROM dydt_data_line_item where dataSourceCode="APPLICATION_INFO")) THEN 
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT ap.firstName AS applicant_firstname ,ap.lastName AS applicant_lastname ,ap.middleName AS applicant_middlename, 
           ap.gender AS applicant_gender,ap.printName  AS applicant_printname,a.code as application_code,
           s.salutationName as applicant_salutation,ap.birthDate as birth_date,ap.photoUrl as app_photo_url,
           ahr.whetherHostelApplicable as Hostel_Applicable,
           ml.itemValue as correspondance_language,ca.itemValue as current_activity,
           s.salutationNameInOtherLanguage AS applicant_salutation_otr_lang,
           ap.nationalID AS ap_nationalID,ap.category AS category,ap.postNumber AS postNumber,
        ap.accountingKey AS accountingKey,
        ap.personalIncome AS personalIncome,
    ecs.itemValue as "ProgramMajor",
    cc.itemValue as  "AdmissionAcademicTerm"
           FROM application a
           LEFT JOIN  applicant_person ap ON a.applicantPersonId = ap.id
           LEFT JOIN exam_center_csm ecs on ecs.id=ap.exam_center_csm_id
           LEFT JOIN caste_categories cc on cc.id=ap.casteCategoryId
           LEFT JOIN applicant_hostel_requirement ahr ON ahr.applicantPersonId = ap.id
           LEFT JOIN salutations s ON ap.salutationId = s.id
           LEFT JOIN current_activity ca on ca.id = ap.current_activity_id
           LEFT JOIN multi_language ml ON ml.id = ap.correspondence_language',
    `resultColumnsDef` = 'applicant_firstname,applicant_lastname,applicant_middlename,applicant_gender,applicant_printname,application_code,applicant_salutation,birth_date,app_photo_url,Hostel_Applicable,correspondance_language,current_activity,applicant_salutation_otr_lang,ap_nationalID,category,postNumber,accountingKey,personalIncome,ProgramMajor,AdmissionAcademicTerm'
WHERE id = (
    SELECT * FROM (
        SELECT MAX(id)
        FROM dydt_data_line_item 
        WHERE dataSourceCode = "APPLICATION_INFO"
    ) AS temp
);
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250715185118__Update_DataProviderForOfferLetter () $$
DROP PROCEDURE IF EXISTS V20250715185118__Update_DataProviderForOfferLetter $$
DELIMITER ;