DELIMITER $$
DROP PROCEDURE IF EXISTS V20250724181154__Insert_AssignExamConcessionTrans $$
CREATE PROCEDURE V20250724181154__Insert_AssignExamConcessionTrans()
BEGIN

IF NOT EXISTS (
    SELECT * FROM `ui_translation` 
    WHERE objectName = 'MESSAGING_TRANSLATIONS' 
      AND keyName = 'ASSIGNEE_EXAM_CONCESSION_REQUEST'
) THEN
INSERT INTO `ui_translation` (
    `objectName`, `keyName`, `defaultValue`, `customerDefineValue`, 
    `russLanguage`, `frenLanguage`, `afriLanguage`, `vietLanguage`, `spanLanguage`, 
    `lastUpdate`, `lastUpdatedBy`
)
VALUES (
    'MESSAGING_TRANSLATIONS', 'ASSIGNEE_EXAM_CONCESSION_REQUEST',
    'Assignee Exam Concession Request', 'Assignee Exam Concession Request',
    NULL, NULL, 'Toegewyse eksamenvrystellingsversoek', 'Yêu cầu miễn thi của người được phân công', NULL,
    NOW(), 1
);
END IF;


IF NOT EXISTS (
    SELECT * FROM `picklist_translation` 
    WHERE `key` = 'ASSIGNEE_EXAM_CONCESSION_REQUEST'
) THEN
INSERT INTO `picklist_translation` (`key`, `en`)
VALUES ('ASSIGNEE_EXAM_CONCESSION_REQUEST', 'Assignee Exam Concession Request');
END IF;


END $$
CALL V20250724181154__Insert_AssignExamConcessionTrans() $$
DROP PROCEDURE IF EXISTS V20250724181154__Insert_AssignExamConcessionTrans $$
DELIMITER ;