DELIMITER $$
DROP PROCEDURE IF EXISTS getSAGEReceiptsData $$
CREATE PROCEDURE `getSAGEReceiptsData` (
    IN academyLocationId BIGINT,
    IN studentCode varchar(25),
    IN receiptFromDate DATE,
    IN receiptToDate DATE,
    IN creationFromDate DATE,
    IN creationToDate DATE,
    IN lastUpdatedFromDate DATE,
    IN lastUpdatedToDate DATE
)
BEGIN
    SELECT 
        Date(rh.transactionDate) AS `receiptDate`,
        u.code AS `studentAccountNumber`,
        cc.itemCode AS `costCenter`,
		CONCAT(rh.amount, ' ', c.currencyCode) AS `paymentAmount`,
        rh.narration AS `description`,
        rh.receiptNo AS `paymentReference`,
        rh.status AS `status`,
        DATE(rh.creationDateTime) AS `createdDate`,
        DATE(rh.lastUpdate) AS `updatedDate`	
    FROM receipt_header rh
    LEFT JOIN users u ON rh.studentId = u.id
    LEFT JOIN academy_location al ON rh.academyLocationId = al.id
    LEFT JOIN cost_centre cc on rh.costCentreId=cc.id
	LEFT JOIN currency c ON rh.currencyId = c.id
    WHERE rh.amount > 0
      AND (academyLocationId IS NULL OR al.id = academyLocationId)
      AND (studentCode IS NULL OR u.code = studentCode)
      AND (receiptFromDate IS NULL OR Date(rh.transactionDate) >= receiptFromDate)
      AND (receiptToDate IS NULL OR Date(rh.transactionDate) <= receiptToDate)
      AND (creationFromDate IS NULL OR DATE(rh.creationDateTime) >= creationFromDate)
      AND (creationToDate IS NULL OR DATE(rh.creationDateTime) <= creationToDate)
      AND (lastUpdatedFromDate IS NULL OR DATE(rh.lastUpdate) >= lastUpdatedFromDate)
      AND (lastUpdatedToDate IS NULL OR DATE(rh.lastUpdate) <= lastUpdatedToDate)
    GROUP BY rh.id;
END$$

DELIMITER ;