DELIMITER $$
DROP PROCEDURE IF EXISTS V20250806152911__Create_PeriodDetailsListDataProvider $$
CREATE PROCEDURE V20250806152911__Create_PeriodDetailsListDataProvider()
BEGIN
IF EXISTS (SELECT id FROM  dydt_data_provider where providerName = 'Inactive Admission Data Providers') THEN
SET @dydtdatalinitemId=(SELECT MAX(id) FROM dydt_data_line_item);
SET @dydtdataproviderId = (SELECT dataProviderId FROM dydt_data_line_item where dataSourceCode='INACTIVE_ADMISSION_DATA_PROVIDERS');
IF NOT EXISTS (SELECT * FROM dydt_data_line_item WHERE dataProviderId = @dydtdataproviderId AND id = @dydtdatalinitemId) THEN
INSERT INTO dydt_data_line_item (id, dataProviderId, dataSourceCode, executionOrder, publishAsParametersDef, whetherDataSource, whetherPrimaryDataSource, sqlSelectQueryDef
, whereClauseBindingDef, resultColumnsDef, sqlWhereQueryDef, whetherMultiRecord)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'PERIOD_DETAILS_LIST', '6',null, '1', '0', 
            'SELECT
                CONCAT(
                    ''<table border="1" style="border-collapse: collapse;width:100%"> '',
                    ''<tr>'',
                    ''<th style="padding: 5px;">Required Courses - '', pbpc.printName, '' '',
                    IF(
                        EXISTS (
                            SELECT 1
                            FROM program_batch_students pbs
                            WHERE pbs.admissionId = sce.admissionId
                            AND pbs.isCurrentPeriod = TRUE
                            AND pbs.isCurrentSection = TRUE
                            AND pbs.isPeriodCompleted = FALSE
                            AND pbs.exitDate IS NULL
                            AND pbpc.id = pbs.progBatchPeriodConfigId
                        ),
                        ''- (Current)'',
                        ''''
                    ),
                    ''</th>'',
                    ''<th style="padding: 5px;">Credits</th>'',
                    ''<th style="padding: 5px;">Teaching Hours</th>'',
                    ''<th style="padding: 5px;">Learning Hours</th>'',
                    ''</tr>'',

                    GROUP_CONCAT(
                        CONCAT(
                            ''<tr>'',
                            ''<td style="padding: 5px;">'', COALESCE(c.courseName, ''''), ''</td>'',
                            ''<td style="padding: 5px;">'', COALESCE(FLOOR(c.courseCredits), 0), ''</td>'',
                            ''<td style="padding: 5px;">'', COALESCE(lp.topics, 0), ''</td>'',
                            ''<td style="padding: 5px;">'', COALESCE(lp.term, 0), ''</td>'',
                            ''</tr>''
                        ) SEPARATOR ''''
                    ),

                    ''<tr>'',
                    ''<td style="padding: 5px;"><b>Total</b></td>'',
                    ''<td style="padding: 5px;"><b>'', COALESCE(SUM(FLOOR(c.courseCredits)), 0), ''</b></td>'',
                    ''<td style="padding: 5px;"><b>'', COALESCE(SUM(lp.topics), 0), ''</b></td>'',
                    ''<td style="padding: 5px;"><b>'', COALESCE(SUM(lp.term), 0), ''</b></td>'',
                    ''</tr>'',
                    ''</table><br></br>''
                )AS PERIOD_DETAIL
            FROM student_course_enrollment sce
            INNER JOIN prog_batch_period_config pbpc ON sce.programBatchPeriodConfigId = pbpc.id
            INNER JOIN admission adm ON adm.id = sce.admissionId
            INNER JOIN course_variants cv ON cv.id = sce.courseVarientId
            LEFT JOIN courses c ON c.id = cv.courseId
            LEFT JOIN lesson_plan lp ON lp.courseId = cv.courseId AND pbpc.academicTermId = lp.academicTermId','PRM_ADMISSION_ID','PERIOD_DETAIL',
            'WHERE adm.id = PRM_ADMISSION_ID AND sce.exitDate IS NULL GROUP BY pbpc.id','1');
END IF;
END IF;
SET @dataLineItemId = (SELECT id FROM dydt_data_line_item WHERE dataSourceCode = 'INACTIVE_ADMISSION_DATA_PROVIDERS');
IF NOT EXISTS (SELECT * FROM dydt_templateparams_translations WHERE dataProviderLineItemId = @dataLineItemId AND translationCode = 'PERIOD_DETAIL') THEN
INSERT INTO dydt_templateparams_translations (translationCode, translationValue, dataProviderLineItemId)
VALUES ('PERIOD_DETAIL', 'Period Detail', @dataLineItemId);
END IF;

END $$
CALL V20250806152911__Create_PeriodDetailsListDataProvider () $$ 
DROP PROCEDURE IF EXISTS V20250806152911__Create_PeriodDetailsListDataProvider $$ 
DELIMITER ;