DELIMITER $$
DROP PROCEDURE IF EXISTS V20250908232459__Update_deenrollmsgeventsqlquery $$
CREATE PROCEDURE V20250908232459__Update_deenrollmsgeventsqlquery()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS (SELECT id FROM dtprovider WHERE dataProviderName = 'COURSE_DE_ENROLLMENT_CONFIRMATION_PORTALS_RCPNT') THEN 
SET @dtproviderid = (SELECT id FROM dtprovider WHERE dataProviderName = 'COURSE_DE_ENROLLMENT_CONFIRMATION_PORTALS_RCPNT');

 UPDATE sql_dtprovider 
    SET sqlQuery = 'SELECT DISTINCT
    T2.id AS ID,
    T18.firstName AS FIRST_NAME,
    T18.lastName AS LAST_NAME,
	T7.displayName AS ACADEMY_LOCATION,
	T7.academyName AS ACADEMY_NAME,
    T7.locationName AS LOCATION_NAME,
	T5.programNameToBePrint AS PROGRAM_NAME,
    T4.printName AS INTAKE_NAME,
    T6.printName AS PERIOD_NAME,
    T17.code AS STUDENT_ID,
    T17.printName as STUDENT_NAME,
    T2.code AS ADMISSION_ID,
    T18.emailId AS EMAIL_ID,
    T18.alternateEmailId as SECONDARY_EMAIL_ID,
    T18.mobileNumber AS MOBILE_NO,
    T18.mobileCountryCode AS MOBILE_CODE,
	GROUP_CONCAT(DISTINCT T20.courseVariantCode) AS COURSE_VARIANTS,
    GROUP_CONCAT(DISTINCT T21.courseName) AS COURSE_NAME,
	(SELECT 
        GROUP_CONCAT(DISTINCT T30.courseVariantCode)
     FROM student_course_deenrollment_event a
     JOIN course_variants T30 ON T30.id = a.courseVariantId
     WHERE a.admissionId = T2.id and a.sendStatus=false
    ) AS DEENROLLED_VARIANTS,
    (SELECT 
        GROUP_CONCAT(DISTINCT c.courseName)
     FROM student_course_deenrollment_event a
     JOIN course_variants cv ON cv.id = a.courseVariantId
     JOIN courses c ON c.id = cv.courseId
     WHERE a.admissionId = T2.id and a.sendStatus=false
    ) AS DEENROLLED_COURSES,
    (SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info
        WHERE
            fire_base_persons_info.userId = T3.userId) AS DEVICE_ID
FROM
    program_batch_students T1
        LEFT OUTER JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT OUTER JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT OUTER JOIN
    batches T4 ON T1.programBatchId = T4.id
        LEFT OUTER JOIN
    programs T5 ON T4.programId = T5.id
        LEFT OUTER JOIN
    prog_batch_period_config T6 ON T1.progBatchPeriodConfigId = T6.id
        LEFT OUTER JOIN
    academy_location T7 on T7.id = T5.academyLocationId
        LEFT OUTER JOIN
    academy_location_addresses ala on ala.academyLocationId = T7.id
        LEFT OUTER JOIN
    address T9 ON T9.id = ala.addressId 
        LEFT OUTER JOIN
    city T10 ON T10.id = T9.cityId
        LEFT OUTER JOIN
    country T11 ON T11.id = T10.countryId
        LEFT OUTER JOIN
    country_region T12 ON T12.id = T10.countryRegionId
        LEFT OUTER JOIN
    prog_batch_seat_config T13 on T13.id = T1.progBatchSeatConfigId
        LEFT OUTER JOIN
    seat_types T14 on T14.id = T13.seatTypeId
        LEFT OUTER JOIN
    academic_term T15 on T15.id = T6.academicTermId
        LEFT OUTER JOIN
    intake_year T16 on T16.id = T4.intakeYearId
        LEFT OUTER JOIN
    users T17 on T17.id = T3.userId
        LEFT OUTER JOIN
    persons T18 on T18.id = T3.personId
     LEFT OUTER JOIN  
     student_course_enrollment T19 on T19.admissionId=T2.id  AND T19.programBatchPeriodConfigId >= (
       SELECT pbs.progBatchPeriodConfigId 
       FROM program_batch_students pbs 
       WHERE pbs.admissionId=(namedParams)
         AND pbs.isCurrentPeriod=true 
         AND pbs.isCurrentSection=true 
         AND pbs.exitDate is null)
     LEFT OUTER JOIN 
     course_variants T20 on T20.id=T19.courseVarientId
     LEFT OUTER JOIN
     courses T21 on T21.id=T20.courseId
     LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE T1.isCurrentPeriod=true AND T1.isCurrentSection=true AND T1.exitDate is null AND T2.id in (namedParams)'
    WHERE dataProviderId = @dtproviderid;
 
 END IF;
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250908232459__Update_deenrollmsgeventsqlquery () $$
DROP PROCEDURE IF EXISTS V20250908232459__Update_deenrollmsgeventsqlquery $$
DELIMITER ;