DELIMITER $$
DROP PROCEDURE IF EXISTS V20250915113039__Insert_uiTranslations $$
CREATE PROCEDURE V20250915113039__Insert_uiTranslations()
BEGIN

-- REVOKED
IF NOT EXISTS (
    (SELECT * FROM `ui_translation` 
     WHERE keyName = 'REVOKED' 
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`, `vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('STUDENTRESPONSIVEPORTAL','REVOKED','Revoked','Revoked','Đã bị thu hồi','Herroep',now(),1);
END IF;

-- ALLOCATED
IF NOT EXISTS (
    (SELECT * FROM `ui_translation` 
     WHERE keyName = 'ALLOCATED' 
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES 
('STUDENTRESPONSIVEPORTAL',
 'ALLOCATED',
 'Allocated',
 'Allocated',
 'Đã được phân bổ',
 'Toegeken',
 now(),
 1);
END IF;

-- HOSTEL_CHOICES
IF NOT EXISTS (
    (SELECT * FROM `ui_translation` 
     WHERE keyName = 'HOSTEL_CHOICES' 
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES 
('STUDENTRESPONSIVEPORTAL',
 'HOSTEL_CHOICES',
 'Hostel Choices',
 'Hostel Choices',
 'Lựa chọn ký túc xá',
 'Koshuise Keuses',
 now(),
 1);
END IF;

-- READ_ACCEPT_ACCOMODATION
IF NOT EXISTS (
    (SELECT * FROM `ui_translation` 
     WHERE keyName = 'READ_ACCEPT_ACCOMODATION' 
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES 
('STUDENTRESPONSIVEPORTAL',
 'READ_ACCEPT_ACCOMODATION',
 'I have read and accept the accomodation (re)application',
 'I have read and accept the accomodation (re)application',
 'Tôi đã đọc và chấp nhận đơn đăng ký (lại) chỗ ở',
 'Ek het die akkommodasie (her)aansoek gelees en aanvaar',
 now(),
 1);
END IF;

-- TERMS_AND_CONDITION
IF NOT EXISTS (
    (SELECT * FROM `ui_translation` 
     WHERE keyName = 'TERMS_AND_CONDITION' 
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES 
('STUDENTRESPONSIVEPORTAL',
 'TERMS_AND_CONDITION',
 'terms and condition',
 'terms and condition',
 'Điều khoản và điều kiện',
 'Bepalings en Voorwaardes',
 now(),
 1);
END IF;

-- REVOKE_CONFIRMATION
IF NOT EXISTS (
    (SELECT * FROM `ui_translation` 
     WHERE keyName = 'REVOKE_CONFIRMATION' 
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES 
('STUDENTRESPONSIVEPORTAL',
 'REVOKE_CONFIRMATION',
 'Are you sure you want to revoke this application?',
 'Are you sure you want to revoke this application?',
 'Bạn có chắc chắn muốn thu hồi đơn này không?',
 'Is jy seker jy wil hierdie aansoek herroep?',
 now(),
 1);
END IF;

-- REVOKED_SUCCESS_MSG
IF NOT EXISTS (
    (SELECT * FROM `ui_translation` 
     WHERE keyName = 'REVOKED_SUCCESS_MSG' 
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES 
('STUDENTRESPONSIVEPORTAL',
 'REVOKED_SUCCESS_MSG',
 'Hostel Application Successfully Revoked',
 'Hostel Application Successfully Revoked',
 'Đơn ký túc xá đã được thu hồi thành công',
 'Koshuisaansoek suksesvol herroep',
 now(),
 1);
END IF;

-- APPLICATION_CANCELLATION_NOT_ALLOWED
IF NOT EXISTS (
    (SELECT * FROM `ui_translation` 
     WHERE keyName = 'APPLICATION_CANCELLATION_NOT_ALLOWED' 
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES 
('STUDENTRESPONSIVEPORTAL',
 'APPLICATION_CANCELLATION_NOT_ALLOWED',
 'Application cancellation is not allowed. Please contact the administrator.',
 'Application cancellation is not allowed. Please contact the administrator.',
 'Không được phép hủy đơn. Vui lòng liên hệ với quản trị viên.',
 'Aansoek-kansellasie word nie toegelaat nie. Kontak asseblief die administrateur.',
 now(),
 1);
END IF;

-- HOSTEL_APPLICATION_SUCCESS
IF NOT EXISTS (
    (SELECT * FROM `ui_translation` 
     WHERE keyName = 'HOSTEL_APPLICATION_SUCCESS' 
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES 
('STUDENTRESPONSIVEPORTAL',
 'HOSTEL_APPLICATION_SUCCESS',
 'Hostel application submitted successfully',
 'Hostel application submitted successfully',
 'Đơn ký túc xá đã được nộp thành công',
 'Koshuisaansoek suksesvol ingedien',
 now(),
 1);
END IF;


-- REVOKED_DATE_PASSED
IF NOT EXISTS (
    (SELECT * FROM `ui_translation` 
     WHERE keyName = 'REVOKED_DATE_PASSED' 
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES 
('STUDENTRESPONSIVEPORTAL',
 'REVOKED_DATE_PASSED',
 'The application cancellation deadline has passed. Please contact the administrator for further assistance.',
 'The application cancellation deadline has passed. Please contact the administrator for further assistance.',
 'Hạn chót hủy đơn đã qua. Vui lòng liên hệ với quản trị viên để được hỗ trợ thêm.',
 'Die sperdatum vir kansellasie van die aansoek het verbygegaan. Kontak asseblief die administrateur vir verdere hulp.',
 now(),
 1);
END IF;

-- APPLICATION_NOT_STARTED
IF NOT EXISTS (
    (SELECT * FROM `ui_translation` 
     WHERE keyName = 'APPLICATION_NOT_STARTED' 
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES 
('STUDENTRESPONSIVEPORTAL',
 'APPLICATION_NOT_STARTED',
 'The application has not started yet',
 'The application has not started yet',
 'Đơn chưa bắt đầu',
 'Die aansoek het nog nie begin nie',
 now(),
 1);
END IF;

-- RE_ALLOCATION_HOSTEL
IF NOT EXISTS (
    (SELECT * FROM `ui_translation` 
     WHERE keyName = 'RE_ALLOCATION_HOSTEL' 
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES 
('STUDENTRESPONSIVEPORTAL',
 'RE_ALLOCATION_HOSTEL',
 'Re-allocate me to my current junior hostel if no space is available in a senior hostel',
 'Re-allocate me to my current junior hostel if no space is available in a senior hostel',
 'Phân bổ lại cho tôi vào ký túc xá hiện tại của sinh viên năm dưới nếu không còn chỗ trong ký túc xá năm trên',
 'Herallokeer my na my huidige junior koshuis as daar geen plek in ’n senior koshuis beskikbaar is nie',
 now(),
 1);
END IF;

-- WAITING_LIST_SETUP
IF NOT EXISTS (
    (SELECT * FROM `ui_translation` 
     WHERE keyName = 'WAITING_LIST_SETUP' 
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES 
('STUDENTRESPONSIVEPORTAL',
 'WAITING_LIST_SETUP',
 'Waiting List Application',
 'Waiting List Application',
 'Đơn danh sách chờ',
 'Waglys Aansoek',
 now(),
 1);
END IF;

-- HOSTEL_GENERAL_SETUP
IF NOT EXISTS (
    (SELECT * FROM `ui_translation` 
     WHERE keyName = 'HOSTEL_GENERAL_SETUP' 
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`, `afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES 
('STUDENTRESPONSIVEPORTAL',
 'HOSTEL_GENERAL_SETUP',
 'General Application',
 'General Application',
 'Đơn chung',
 'Algemene Aansoek',
 now(),
 1);
END IF;


-- TYPE_TO_SEARCH
IF NOT EXISTS (
    (SELECT * FROM `ui_translation`
     WHERE keyName = 'TYPE_TO_SEARCH'
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('STUDENTRESPONSIVEPORTAL',
 'TYPE_TO_SEARCH',
 'Enter 3 char to auto search',
 'Enter 3 char to auto search',
 'Nhập 3 ký tự để tự động tìm kiếm',
 'Voer 3 karakters in om outomaties te soek',
 now(),
 1);
END IF;

-- GENERATED_ON
IF NOT EXISTS (
    (SELECT * FROM `ui_translation`
     WHERE keyName = 'GENERATED_ON'
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('STUDENTRESPONSIVEPORTAL',
 'GENERATED_ON',
 'Generated On',
 'Generated On',
 'Được tạo vào',
 'Gegenereer op',
 now(),
 1);
END IF;

-- REQUEST_REASON_REMARK
IF NOT EXISTS (
    (SELECT * FROM `ui_translation`
     WHERE keyName = 'REQUEST_REASON_REMARK'
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('STUDENTRESPONSIVEPORTAL',
 'REQUEST_REASON_REMARK',
 'Request Reason/Remark',
 'Request Reason/Remark',
 'Lý do/Ý kiến yêu cầu',
 'Versoek Rede/Opmerking',
 now(),
 1);
END IF;

-- FILL_READMISSION_FORM
IF NOT EXISTS (
    (SELECT * FROM `ui_translation`
     WHERE keyName = 'FILL_READMISSION_FORM'
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('STUDENTRESPONSIVEPORTAL',
 'FILL_READMISSION_FORM',
 'Fill Readmission Form',
 'Fill Readmission Form',
 'Điền đơn xin nhập học lại',
 'Vul herinskrywingsvorm in',
 now(),
 1);
END IF;

-- INTENDED_FACULTY_STUDY
IF NOT EXISTS (
    (SELECT * FROM `ui_translation`
     WHERE keyName = 'INTENDED_FACULTY_STUDY'
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('STUDENTRESPONSIVEPORTAL',
 'INTENDED_FACULTY_STUDY',
 'Intended Faculty of study',
 'Intended Faculty of study',
 'Khoa dự định học',
 'Beoogde Fakulteit van Studie',
 now(),
 1);
END IF;

-- INTENDED_PROGRAM_OF_STUDY
IF NOT EXISTS (
    (SELECT * FROM `ui_translation`
     WHERE keyName = 'INTENDED_PROGRAM_OF_STUDY'
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('STUDENTRESPONSIVEPORTAL',
 'INTENDED_PROGRAM_OF_STUDY',
 'Intended program of study',
 'Intended program of study',
 'Chương trình dự định học',
 'Beoogde Program van Studie',
 now(),
 1);
END IF;

-- PLEASE_READ_TERMS_GUIDELINES
IF NOT EXISTS (
    (SELECT * FROM `ui_translation`
     WHERE keyName = 'PLEASE_READ_TERMS_GUIDELINES'
       AND objectName = 'STUDENTRESPONSIVEPORTAL')
) THEN
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,
 `vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('STUDENTRESPONSIVEPORTAL',
 'PLEASE_READ_TERMS_GUIDELINES',
 'Please make sure to read the <a>Terms and Guidelines</a> before completing the application form. It is important to understand the requirements and guidelines to ensure all information and documents are submitted correctly. By following these guidelines, you will increase your chances of a successful readmission application.',
 'Please make sure to read the <a>Terms and Guidelines</a> before completing the application form. It is important to understand the requirements and guidelines to ensure all information and documents are submitted correctly. By following these guidelines, you will increase your chances of a successful readmission application.',
 'Vui lòng đọc <a>Điều khoản và Hướng dẫn</a> trước khi hoàn thành đơn. Việc hiểu rõ yêu cầu và hướng dẫn sẽ đảm bảo bạn nộp đủ thông tin và tài liệu. Tuân thủ hướng dẫn sẽ tăng cơ hội được nhập học lại.',
 'Lees asseblief die <a>Bepalings en Riglyne</a> voordat jy die aansoekvorm voltooi. Dit is belangrik om die vereistes en riglyne te verstaan om te verseker dat alle inligting en dokumente korrek ingedien word. Deur hierdie riglyne te volg, verhoog jy jou kans op ’n suksesvolle herinskrywing.',
 now(),
 1);
END IF;




END $$
CALL V20250915113039__Insert_uiTranslations() $$
DROP PROCEDURE IF EXISTS V20250915113039__Insert_uiTranslations $$
DELIMITER ;