DELIMITER $$
DROP PROCEDURE IF EXISTS V20250916160205__Insert_stdCorseFeePayer $$
CREATE PROCEDURE V20250916160205__Insert_stdCorseFeePayer()
BEGIN

IF EXISTS(SELECT 1
    FROM dydt_data_provider 
    WHERE providerName = 'Registration Amendment Letter Dynamic Document') THEN
SET @dataProviderId = (
    SELECT MAX(id) 
    FROM dydt_data_provider 
    WHERE providerName = 'Registration Amendment Letter Dynamic Document'
);
END IF;

SET @dydtdatalinitemId = (
    SELECT MAX(id) 
    FROM dydt_data_line_item
);

IF NOT EXISTS (
    SELECT 1 
    FROM dydt_data_line_item 
    WHERE dataSourceCode = 'STUDENT_COURSE_ENROLLMENT_INFO'  
      AND dataProviderId = @dataProviderId
) THEN

INSERT INTO `dydt_data_line_item`
(`id`,`dataProviderId`,`dataSourceCode`,`executionOrder`,
 `publishAsParametersDef`,`whetherDataSource`,`whetherPrimaryDataSource`,
 `sqlSelectQueryDef`,`whereClauseBindingDef`,`resultColumnsDef`,
 `formattersDef`,`sqlWhereQueryDef`,`whetherMultiRecord`)
VALUES
(
    @dydtdatalinitemId + 1,
    @dataProviderId,
    'STUDENT_COURSE_ENROLLMENT_INFO',
    2,
    NULL,
    1,
    0,
    'SELECT 
        IFNULL(co.courseCode, c.courseCode) AS COURSE_CODE,
        IFNULL(co.courseName, c.courseName) AS COURSE_NAME,
        FLOOR(c.courseCredits) AS COURSE_CREDITS, 
        pbpc.printName AS PERIOD, 
        ss.examDate AS EXAM_DATE, 
        DATE_FORMAT(ss.examStartTime,''%h:%i %p'') AS EXAM_START_TIME, 
        DATE_FORMAT(ss.examEndTime,''%h:%i %p'') AS EXAM_END_TIME,
        IFNULL(IF(program_courses.isOfferedYearly = 1,''Yes'',''No''),''No'') AS YEARLY_MODULE,
        bh.totalAmount AS COURSE_ENROLLMENT_BILL_AMOUNT,
        sce.enrollCourseStatus AS MODULE_TYPE
     FROM student_course_enrollment sce
     INNER JOIN prog_batch_period_config pbpc 
         ON sce.programBatchPeriodConfigId = pbpc.id
     LEFT JOIN period_year py 
         ON pbpc.periodYearId = py.id
     INNER JOIN admission adm 
         ON adm.id = sce.admissionId
     INNER JOIN course_variants cv 
         ON cv.id = sce.courseVarientId
     INNER JOIN sections ss 
         ON ss.id = sce.sectionId
     LEFT JOIN courses c 
         ON c.id = cv.courseId
     LEFT JOIN courses co 
         ON co.id = c.parentCourseId
     LEFT JOIN program_courses 
         ON c.parentCourseId = program_courses.courseId 
        AND pbpc.programBatchId = program_courses.programBatchId
     LEFT JOIN bill_header bh 
         ON sce.billId = bh.id',
    'PRM_STUDENT_ID',
    'COURSE_CODE, COURSE_NAME, COURSE_CREDITS, PERIOD, EXAM_DATE, EXAM_START_TIME, EXAM_END_TIME, YEARLY_MODULE, COURSE_ENROLLMENT_BILL_AMOUNT, MODULE_TYPE',
    NULL,
    'WHERE adm.id = PRM_STUDENT_ID
      AND sce.exitDate IS NULL
      AND adm.activeStatus = TRUE
      AND EXISTS (
            SELECT 1 
            FROM drop_down dd 
            WHERE dd.name = ''Yearly Proof of Registration''
              AND (
                    (LOWER(IFNULL(dd.value, '''')) = ''no'' 
                     AND sce.programBatchPeriodConfigId >= (
                         SELECT MAX(pbs.progBatchPeriodConfigId)
                         FROM program_batch_students pbs
                         WHERE pbs.admissionId = PRM_STUDENT_ID
                           AND pbs.isCurrentPeriod = TRUE
                           AND pbs.isCurrentSection = TRUE
                           AND pbs.exitDate IS NULL
                     )
                    )
                    OR
                    (LOWER(IFNULL(dd.value, '''')) = ''yes''
                     AND py.id = (
                         SELECT MAX(pyp.id)
                         FROM program_batch_students pbs
                         JOIN prog_batch_period_config pbpcp 
                           ON pbs.progBatchPeriodConfigId = pbpcp.id
                         JOIN period_year pyp 
                           ON pbpcp.periodYearId = pyp.id
                         WHERE pbs.admissionId = PRM_STUDENT_ID
                           AND pbs.isCurrentPeriod = TRUE
                           AND pbs.isCurrentSection = TRUE
                           AND pbs.exitDate IS NULL
                     )
                    )
                  )
      )',
    1
);

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('COURSE_CODE', 'Course Code',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('COURSE_NAME', 'Course Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('COURSE_CREDITS', 'Course Credits',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('PERIOD', 'Period',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('EXAM_DATE', 'Exam Date',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('EXAM_START_TIME', 'Exam Start Time',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('EXAM_END_TIME', 'End Time',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('YEARLY_MODULE', 'Yearly Module',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('COURSE_ENROLLMENT_BILL_AMOUNT', 'Course_Enrollment_Bill_Amount',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('COURSE_ENROLLMENT_BILL_AMOUNT', 'Course_Enrollment_Bill_Amount',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('MODULE_TYPE', 'Module Type',@dydtdatalinitemId+1);

END IF;

END $$
CALL V20250916160205__Insert_stdCorseFeePayer() $$
DROP PROCEDURE IF EXISTS V20250916160205__Insert_stdCorseFeePayer $$
DELIMITER ;