/* ***************** applicant_person ************************ */

CREATE TABLE `applicant_person` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mobileNumber` varchar(15) DEFAULT NULL,
  `employeeId` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) NOT NULL,
  `middleName` varchar(255) DEFAULT NULL,
  `emailId` varchar(100) DEFAULT NULL,
  `lastName` varchar(255) NOT NULL,
  `shortName` varchar(255) NOT NULL,
  `birthDate` date NOT NULL,
  `bloodGroup` varchar(20) DEFAULT NULL,
  `gender` varchar(20) NOT NULL,
  `maritalStatus` varchar(20) DEFAULT NULL,
  `category` varchar(255) DEFAULT NULL,
  `occupation` varchar(100) DEFAULT NULL,
  `personalIncome` decimal(18,2) DEFAULT NULL,
  `photoUrl` varchar(255) DEFAULT NULL,
  `salutationId` bigint(20) NOT NULL,
  `casteCategoryId` bigint(20) DEFAULT NULL,
  `nationalityId` bigint(20) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `whetherEmployeeOfOrganization` bit(1) NOT NULL,
  `whetherDeleted` bit(1) NOT NULL,
  `countryId` bigint(20) DEFAULT NULL,
  `printName` varchar(255) DEFAULT NULL,
  `religionId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT  FOREIGN KEY (`salutationId`) REFERENCES `salutations` (`id`),
  CONSTRAINT  FOREIGN KEY (`countryId`) REFERENCES `country` (`id`),
  CONSTRAINT FOREIGN KEY (`religionId`) REFERENCES `religions` (`id`),
  CONSTRAINT FOREIGN KEY (`nationalityId`) REFERENCES `nationalities` (`id`)
);


/* ***************** applicant_bank_details ************************ */

CREATE TABLE `applicant_bank_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `whetherDeleted` bit(1) NOT NULL,
  `branchName` char(100) NOT NULL,
  `accountNumber` varchar(50) NOT NULL,
  `applicantPersonId` bigint(20) NOT NULL,
  `IFSCode` varchar(50) NOT NULL,
  `bankName` varchar(100) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT FOREIGN KEY (`lastUpdatedby`) REFERENCES `users` (`id`)
);


/* ***************** applicant_address ************************ */

CREATE TABLE `applicant_address` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint(20) NOT NULL,
  `code` char(10) DEFAULT NULL,
  `addressText` varchar(255) DEFAULT NULL,
  `cityId` bigint(20) NOT NULL,
  `phoneNo` varchar(15) DEFAULT NULL,
  `phoneCountryCode` varchar(10) DEFAULT NULL,
  `phoneAreaCode` int(11) DEFAULT NULL,
  `cellNo` bigint(20) DEFAULT NULL,
  `cellCountryCode` char(10) DEFAULT NULL,
  `primaryEmailId` varchar(100) DEFAULT NULL,
  `alternateEmailId` varchar(100) DEFAULT NULL,
  `countryRegionId` bigint(20) DEFAULT NULL,
  `addressTypeId` bigint(20) DEFAULT NULL,
  `parentRegionId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT  FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT  FOREIGN KEY (`countryRegionId`) REFERENCES `country_region` (`id`),
  CONSTRAINT  FOREIGN KEY (`addressTypeId`) REFERENCES `address_type` (`id`),
  CONSTRAINT  FOREIGN KEY (`parentRegionId`) REFERENCES `country_region` (`id`),
  CONSTRAINT  FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT  FOREIGN KEY (`cityId`) REFERENCES `city` (`id`)
) ;


/* ***************** applicant_person_relationships ************************ */

CREATE TABLE `applicant_person_relationships` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint(20) NOT NULL,
  `relatedApplicantPersonId` bigint(20) NOT NULL,
  `relationship` varchar(20) NOT NULL,
  `whetherDeleted` bit(1) NOT NULL DEFAULT b'0',
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT  FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT  FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);


/* ***************** applicant_education_histories ************************ */

CREATE TABLE `applicant_education_histories` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint(20) NOT NULL,
  `enrollmentNumber` varchar(100) DEFAULT NULL,
  `examName` varchar(255) NOT NULL,
  `examConductedBy` varchar(255) NOT NULL,
  `whetherExistingStudent` bit(1) NOT NULL DEFAULT b'0',
  `examResult` varchar(100) NOT NULL,
  `yearPassed` varchar(5) NOT NULL,
  `whetherDeleted` bit(1) NOT NULL DEFAULT b'0',
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` decimal(10,0) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT  FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);


/* ***************** applicant_subject_mark_info ************************ */

CREATE TABLE `applicant_subject_mark_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantEducationHistoryId` bigint(20) NOT NULL,
  `subjectId` bigint(20) NOT NULL,
  `marks` decimal(10,0) NOT NULL,
  `whetherDeleted` bit(1) NOT NULL DEFAULT b'0',
  `version` decimal(10,0) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT  FOREIGN KEY (`applicantEducationHistoryId`) REFERENCES `applicant_education_histories` (`id`),
  CONSTRAINT  FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT  FOREIGN KEY (`subjectId`) REFERENCES `subjects` (`id`)
);


/* ***************** applicant_work_experience ************************ */

CREATE TABLE `applicant_work_experience` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint(20) NOT NULL,
  `workType` varchar(20) DEFAULT NULL,
  `department` varchar(255) DEFAULT NULL,
  `designation` varchar(255) NOT NULL,
  `employer` varchar(255) NOT NULL,
  `duration` float NOT NULL,
  `joiningDate` date NOT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `whetherDeleted` bit(1) NOT NULL DEFAULT b'0',
  `experienceTypeId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` decimal(10,0) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT  FOREIGN KEY (`experienceTypeId`) REFERENCES `experience_types` (`id`)
);


/* ***************** applicant_medical_history ************************ */

CREATE TABLE `applicant_medical_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint(20) NOT NULL,
  `medicalCondition` varchar(255) NOT NULL,
  `dateSince` date DEFAULT NULL,
  `consultingDoctor` varchar(255) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `whetherDeleted` bit(1) NOT NULL DEFAULT b'0',
  `medicalConditonId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` decimal(10,0) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT FOREIGN KEY (`medicalConditonId`) REFERENCES `medical_condition_types` (`id`),
  CONSTRAINT FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);


/* ***************** applicant_vaccination_info ************************ */

CREATE TABLE `applicant_vaccination_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint(20) NOT NULL,
  `name` varchar(255) NOT NULL,
  `purpose` varchar(255) NOT NULL,
  `vaccinationDate` date DEFAULT NULL,
  `whetherDeleted` bit(1) NOT NULL DEFAULT b'0',
  `remarks` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` decimal(10,0) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT  FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT  FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);


/* ***************** applicant_extracurricular_activity ************************ */

CREATE TABLE `applicant_extracurricular_activity` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint(20) NOT NULL,
  `activityName` varchar(255) NOT NULL,
  `activityType` bigint(20) NOT NULL,
  `activityYear` decimal(10,0) NOT NULL,
  `organization` varchar(255) NOT NULL,
  `performance` varchar(255) NOT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `whetherCurrentOrganization` bit(1) NOT NULL DEFAULT b'0',
  `whetherDeleted` bit(1) NOT NULL DEFAULT b'0',
  `communityId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` decimal(10,0) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT FOREIGN KEY (`activityType`) REFERENCES `activity_type` (`id`),
  CONSTRAINT FOREIGN KEY (`communityId`) REFERENCES `community` (`id`),
  CONSTRAINT FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);


/* ***************** applicant_person_training ************************ */

CREATE TABLE `applicant_person_training` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint(20) NOT NULL,
  `trainingCategoryId` bigint(20) NOT NULL,
  `trainingName` varchar(100) NOT NULL,
  `fromDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `toDate` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `organization` varchar(100) NOT NULL,
  `whetherDeleted` bit(1) NOT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT  FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);


/* ***************** applicant_person_services ************************ */

CREATE TABLE `applicant_person_services` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `serviceIdentifier` varchar(50) NOT NULL,
  `applicantPersonId` bigint(20) NOT NULL,
  `serviceId` bigint(20) NOT NULL,
  `feePlanId` bigint(20) NOT NULL,
  `fromDate` date NOT NULL,
  `tillDate` date NOT NULL,
  `amountToBePaid` decimal(10,0) NOT NULL,
  `whetherOpted` bit(1) NOT NULL,
  `whetherMandatory` bit(1) NOT NULL DEFAULT b'0',
  `whetherDeleted` bit(1) NOT NULL DEFAULT b'0',
  `status` varchar(10) DEFAULT NULL,
  `remarks` varchar(255) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` decimal(10,0) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT FOREIGN KEY (`feePlanId`) REFERENCES `fee_plan` (`id`),
  CONSTRAINT FOREIGN KEY (`serviceId`) REFERENCES `service` (`id`),
  CONSTRAINT FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);


/* ***************** applicant person_communities ************************ */

CREATE TABLE `applicant_person_communities` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint(20) NOT NULL,
  `communityId` bigint(20) NOT NULL,
  `joiningDate` date NOT NULL,
  `exitDate` date DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `whetherDeleted` bit(1) NOT NULL DEFAULT b'0',
  `whetherOpted` bit(1) NOT NULL,
  `status` varchar(10) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `version` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT FOREIGN KEY (`communityId`) REFERENCES `community` (`id`),
  CONSTRAINT  FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ;

/* ***************** END ************************ */